/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote.protocol.versionone;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.as.ejb3.remote.protocol.versionone.Marshaller;
import org.jboss.as.ejb3.remote.protocol.versionone.MarshallerFactory;
import org.jboss.as.ejb3.remote.protocol.versionone.MessageHandler;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.RemotingAttachments;
import org.jboss.remoting3.Channel;

abstract class AbstractMessageHandler
implements MessageHandler {
    protected final String marshallingStrategy;
    protected static final byte HEADER_NO_SUCH_EJB_FAILURE = 10;
    protected static final byte HEADER_NO_SUCH_EJB_METHOD_FAILURE = 11;
    protected static final byte HEADER_SESSION_NOT_ACTIVE_FAILURE = 12;
    private static final byte HEADER_INVOCATION_EXCEPTION = 6;

    AbstractMessageHandler(String marshallingStrategy) {
        this.marshallingStrategy = marshallingStrategy;
    }

    protected RemotingAttachments readAttachments(DataInput input) throws IOException {
        int numAttachments = input.readByte();
        if (numAttachments == 0) {
            return null;
        }
        RemotingAttachments attachments = new RemotingAttachments();
        for (int i = 0; i < numAttachments; ++i) {
            short attachmentId = input.readShort();
            int dataLength = PackedInteger.readPackedInteger((DataInput)input);
            byte[] data = new byte[dataLength];
            input.readFully(data);
            attachments.putPayloadAttachment((int)attachmentId, data);
        }
        return attachments;
    }

    protected void writeAttachments(DataOutput output, RemotingAttachments attachments) throws IOException {
        if (attachments == null) {
            output.writeByte(0);
            return;
        }
        output.writeByte(attachments.size());
        for (RemotingAttachments.RemotingAttachment attachment : attachments.entries()) {
            output.writeShort(attachment.getKey());
            byte[] data = attachment.getValue();
            PackedInteger.writePackedInteger((DataOutput)output, (int)data.length);
            output.write(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeException(Channel channel, short invocationId, Throwable t, RemotingAttachments attachments) throws IOException {
        DataOutputStream outputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        try {
            outputStream.write(6);
            outputStream.writeShort(invocationId);
            this.writeAttachments(outputStream, attachments);
            Marshaller marshaller = MarshallerFactory.createMarshaller(this.marshallingStrategy);
            marshaller.start(outputStream);
            marshaller.writeObject(t);
            marshaller.finish();
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInvocationFailure(Channel channel, byte messageHeader, short invocationId, String failureMessage) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)channel.writeMessage());
        try {
            dataOutputStream.writeByte(messageHeader);
            dataOutputStream.writeShort(invocationId);
            dataOutputStream.writeUTF(failureMessage);
        }
        finally {
            dataOutputStream.close();
        }
    }

    protected void writeNoSuchEJBFailureMessage(Channel channel, short invocationId, String appName, String moduleName, String distinctname, String beanName, String viewClassName) throws IOException {
        StringBuffer sb = new StringBuffer("No such EJB[");
        sb.append("appname=").append(appName).append(", ");
        sb.append("modulename=").append(moduleName).append(", ");
        sb.append("distinctname=").append(distinctname).append(", ");
        sb.append("beanname=").append(beanName).append(", ");
        sb.append("viewclassname=").append(viewClassName).append("]");
        this.writeInvocationFailure(channel, (byte)10, invocationId, sb.toString());
    }

    protected void writeSessionNotActiveFailureMessage(Channel channel, short invocationId, String appName, String moduleName, String distinctname, String beanName) throws IOException {
        StringBuffer sb = new StringBuffer("Session not active for EJB[");
        sb.append("appname=").append(appName).append(", ");
        sb.append("modulename=").append(moduleName).append(", ");
        sb.append("distinctname=").append(distinctname).append(", ");
        sb.append("beanname=").append(beanName).append("]");
        this.writeInvocationFailure(channel, (byte)12, invocationId, sb.toString());
    }

    protected void writeNoSuchEJBMethodFailureMessage(Channel channel, short invocationId, String appName, String moduleName, String distinctname, String beanName, String viewClassName, String methodName, String[] methodParamTypes) throws IOException {
        StringBuffer sb = new StringBuffer("No such method ");
        sb.append(methodName).append("(");
        if (methodParamTypes != null) {
            for (int i = 0; i < methodParamTypes.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(methodParamTypes[i]);
            }
        }
        sb.append(") on EJB[");
        sb.append("appname=").append(appName).append(", ");
        sb.append("modulename=").append(moduleName).append(", ");
        sb.append("distinctname=").append(distinctname).append(", ");
        sb.append("beanname=").append(beanName).append(", ");
        sb.append("viewclassname=").append(viewClassName).append("]");
        this.writeInvocationFailure(channel, (byte)11, invocationId, sb.toString());
    }
}

