/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.security;

import java.lang.reflect.Method;
import java.util.Set;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.component.EJBComponent;
import org.jboss.as.ejb3.security.EJBMethodSecurityMetaData;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;

public class AuthorizationInterceptor
implements Interceptor {
    private final EJBMethodSecurityMetaData ejbMethodSecurityMetaData;
    private final String viewClassName;
    private final Method viewMethod;

    public AuthorizationInterceptor(EJBMethodSecurityMetaData ejbMethodSecurityMetaData, String viewClassName, Method viewMethod) {
        if (ejbMethodSecurityMetaData == null) {
            throw EjbMessages.MESSAGES.ejbMethodSecurityMetaDataIsNull();
        }
        if (viewClassName == null || viewClassName.trim().isEmpty()) {
            throw EjbMessages.MESSAGES.viewClassNameIsNull();
        }
        if (viewMethod == null) {
            throw EjbMessages.MESSAGES.viewMethodIsNull();
        }
        this.ejbMethodSecurityMetaData = ejbMethodSecurityMetaData;
        this.viewClassName = viewClassName;
        this.viewMethod = viewMethod;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        SimpleSecurityManager securityManager;
        Set<String> allowedRoles;
        Component component = (Component)context.getPrivateData(Component.class);
        if (!(component instanceof EJBComponent)) {
            throw EjbMessages.MESSAGES.unexpectedComponent(component, EJBComponent.class);
        }
        Method invokedMethod = context.getMethod();
        ComponentView componentView = (ComponentView)context.getPrivateData(ComponentView.class);
        String viewClassOfInvokedMethod = componentView.getViewClass().getName();
        if (!this.viewClassName.equals(viewClassOfInvokedMethod) || !this.viewMethod.equals(invokedMethod)) {
            throw EjbMessages.MESSAGES.failProcessInvocation(this.getClass().getName(), invokedMethod, viewClassOfInvokedMethod, this.viewMethod, this.viewClassName);
        }
        EJBComponent ejbComponent = (EJBComponent)component;
        if (this.ejbMethodSecurityMetaData.isAccessDenied()) {
            throw EjbMessages.MESSAGES.invocationOfMethodNotAllowed(invokedMethod, ejbComponent.getComponentName());
        }
        if (!(this.ejbMethodSecurityMetaData.isPermitAll() || (allowedRoles = this.ejbMethodSecurityMetaData.getRolesAllowed()).isEmpty() || (securityManager = ejbComponent.getSecurityManager()).isCallerInRole(ejbComponent.getSecurityMetaData().getSecurityRoles(), allowedRoles.toArray(new String[allowedRoles.size()])))) {
            throw EjbMessages.MESSAGES.invocationOfMethodNotAllowed(invokedMethod, ejbComponent.getComponentName());
        }
        return context.proceed();
    }
}

