/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class ConnectionFactoryWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final ConnectionFactoryWriteAttributeHandler INSTANCE = new ConnectionFactoryWriteAttributeHandler();
    private static final EnumSet<AttributeAccess.Flag> RESTART_NONE = EnumSet.of(AttributeAccess.Flag.RESTART_NONE);
    private static final EnumSet<AttributeAccess.Flag> RESTART_ALL = EnumSet.of(AttributeAccess.Flag.RESTART_ALL_SERVICES);
    private final Map<String, AttributeDefinition> runtimeAttributes = new HashMap<String, AttributeDefinition>();

    private ConnectionFactoryWriteAttributeHandler() {
        super(JMSServices.CONNECTION_FACTORY_ATTRS);
        for (AttributeDefinition attr : JMSServices.CONNECTION_FACTORY_WRITE_ATTRS) {
            this.runtimeAttributes.put(attr.getName(), attr);
        }
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        for (AttributeDefinition attr : JMSServices.CONNECTION_FACTORY_ATTRS) {
            String attrName = attr.getName();
            EnumSet<AttributeAccess.Flag> flags = this.runtimeAttributes.containsKey(attrName) ? RESTART_NONE : RESTART_ALL;
            registry.registerReadWriteAttribute(attrName, null, (OperationStepHandler)this, flags);
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ServiceName hqServiceName;
        AttributeDefinition attr = this.runtimeAttributes.get(attributeName);
        if (attr == null) {
            return true;
        }
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService == null) {
            return false;
        }
        if (hqService.getState() != ServiceController.State.UP) {
            return true;
        }
        this.applyOperationToHornetQService(context, operation, attributeName, hqService);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ServiceName hqServiceName;
        ServiceRegistry registry;
        ServiceController hqService;
        if (this.runtimeAttributes.containsKey(attributeName) && (hqService = (registry = context.getServiceRegistry(true)).getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))))) != null && hqService.getState() == ServiceController.State.UP) {
            ModelNode revertOp = operation.clone();
            revertOp.get(attributeName).set(valueToRestore);
            this.applyOperationToHornetQService(context, revertOp, attributeName, hqService);
        }
    }

    private void applyOperationToHornetQService(OperationContext context, ModelNode operation, String attributeName, ServiceController<?> hqService) {
        block32: {
            String name = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            HornetQServer server = (HornetQServer)HornetQServer.class.cast(hqService.getValue());
            ConnectionFactoryControl control = (ConnectionFactoryControl)ConnectionFactoryControl.class.cast(server.getManagementService().getResource("jms.connectionfactory." + name));
            try {
                if (attributeName.equals(CommonAttributes.CLIENT_ID.getName())) {
                    ModelNode node = CommonAttributes.CLIENT_ID.resolveModelAttribute(context, operation);
                    control.setClientID(node.isDefined() ? node.asString() : null);
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.COMPRESS_LARGE_MESSAGES.getName())) {
                    control.setCompressLargeMessages(CommonAttributes.COMPRESS_LARGE_MESSAGES.resolveModelAttribute(context, operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CLIENT_FAILURE_CHECK_PERIOD.getName())) {
                    control.setClientFailureCheckPeriod(CommonAttributes.CLIENT_FAILURE_CHECK_PERIOD.resolveModelAttribute(context, operation).asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CALL_TIMEOUT.getName())) {
                    control.setCallTimeout(CommonAttributes.CALL_TIMEOUT.resolveModelAttribute(context, operation).asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.DUPS_OK_BATCH_SIZE.getName())) {
                    control.setDupsOKBatchSize(CommonAttributes.DUPS_OK_BATCH_SIZE.resolveModelAttribute(context, operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONSUMER_MAX_RATE.getName())) {
                    control.setConsumerMaxRate(CommonAttributes.CONSUMER_MAX_RATE.resolveModelAttribute(context, operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONSUMER_WINDOW_SIZE.getName())) {
                    control.setConsumerWindowSize(CommonAttributes.CONSUMER_WINDOW_SIZE.resolveModelAttribute(context, operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.PRODUCER_MAX_RATE.getName())) {
                    control.setProducerMaxRate(CommonAttributes.PRODUCER_MAX_RATE.resolveModelAttribute(context, operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONFIRMATION_WINDOW_SIZE.getName())) {
                    control.setConfirmationWindowSize(CommonAttributes.CONFIRMATION_WINDOW_SIZE.resolveModelAttribute(context, operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.BLOCK_ON_ACK.getName())) {
                    control.setBlockOnAcknowledge(CommonAttributes.BLOCK_ON_ACK.resolveModelAttribute(context, operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.BLOCK_ON_DURABLE_SEND.getName())) {
                    control.setBlockOnDurableSend(CommonAttributes.BLOCK_ON_DURABLE_SEND.resolveModelAttribute(context, operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.BLOCK_ON_NON_DURABLE_SEND.getName())) {
                    control.setBlockOnNonDurableSend(CommonAttributes.BLOCK_ON_NON_DURABLE_SEND.resolveModelAttribute(context, operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.PRE_ACK.getName())) {
                    control.setPreAcknowledge(CommonAttributes.PRE_ACK.resolveModelAttribute(context, operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONNECTION_TTL.getName())) {
                    control.setConnectionTTL(CommonAttributes.CONNECTION_TTL.resolveModelAttribute(context, operation).asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.TRANSACTION_BATCH_SIZE.getName())) {
                    control.setTransactionBatchSize(CommonAttributes.TRANSACTION_BATCH_SIZE.resolveModelAttribute(context, operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.MIN_LARGE_MESSAGE_SIZE.getName())) {
                    control.setMinLargeMessageSize(CommonAttributes.MIN_LARGE_MESSAGE_SIZE.resolveModelAttribute(context, operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.AUTO_GROUP.getName())) {
                    control.setAutoGroup(CommonAttributes.AUTO_GROUP.resolveModelAttribute(context, operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.RETRY_INTERVAL.getName())) {
                    control.setRetryInterval(CommonAttributes.RETRY_INTERVAL.resolveModelAttribute(context, operation).asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.RETRY_INTERVAL_MULTIPLIER.getName())) {
                    control.setRetryIntervalMultiplier(CommonAttributes.RETRY_INTERVAL_MULTIPLIER.resolveModelAttribute(context, operation).asDouble());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONNECTION_FACTORY_RECONNECT_ATTEMPTS.getName())) {
                    control.setReconnectAttempts(CommonAttributes.CONNECTION_FACTORY_RECONNECT_ATTEMPTS.resolveModelAttribute(context, operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.FAILOVER_ON_INITIAL_CONNECTION.getName())) {
                    control.setFailoverOnInitialConnection(CommonAttributes.FAILOVER_ON_INITIAL_CONNECTION.resolveModelAttribute(context, operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.PRODUCER_WINDOW_SIZE.getName())) {
                    control.setProducerWindowSize(CommonAttributes.PRODUCER_WINDOW_SIZE.resolveModelAttribute(context, operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CACHE_LARGE_MESSAGE_CLIENT.getName())) {
                    control.setCacheLargeMessagesClient(CommonAttributes.CACHE_LARGE_MESSAGE_CLIENT.resolveModelAttribute(context, operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.MAX_RETRY_INTERVAL.getName())) {
                    control.setMaxRetryInterval(CommonAttributes.MAX_RETRY_INTERVAL.resolveModelAttribute(context, operation).asLong());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONNECTION_SCHEDULED_THREAD_POOL_MAX_SIZE.getName())) {
                    control.setScheduledThreadPoolMaxSize(CommonAttributes.CONNECTION_SCHEDULED_THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.CONNECTION_THREAD_POOL_MAX_SIZE.getName())) {
                    control.setThreadPoolMaxSize(CommonAttributes.CONNECTION_THREAD_POOL_MAX_SIZE.resolveModelAttribute(context, operation).asInt());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.GROUP_ID.getName())) {
                    ModelNode node = CommonAttributes.GROUP_ID.resolveModelAttribute(context, operation);
                    control.setGroupID(node.isDefined() ? node.asString() : null);
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.USE_GLOBAL_POOLS.getName())) {
                    control.setUseGlobalPools(CommonAttributes.USE_GLOBAL_POOLS.resolveModelAttribute(context, operation).asBoolean());
                    break block32;
                }
                if (attributeName.equals(CommonAttributes.LOAD_BALANCING_CLASS_NAME.getName())) {
                    control.setConnectionLoadBalancingPolicyClassName(CommonAttributes.LOAD_BALANCING_CLASS_NAME.resolveModelAttribute(context, operation).asString());
                    break block32;
                }
                throw MessagingMessages.MESSAGES.unsupportedRuntimeAttribute(attributeName);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

