/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.jboss.as.connector.ConnectorMessages;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.metadata.ra.RaParser;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class RaDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ResourceRoot deploymentRoot = (ResourceRoot)phaseContext.getDeploymentUnit().getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile file = deploymentRoot.getRoot();
        if (file == null || !file.exists()) {
            return;
        }
        String deploymentRootName = file.getLowerCaseName();
        if (!deploymentRootName.endsWith(".rar")) {
            return;
        }
        VirtualFile alternateDescriptor = (VirtualFile)deploymentRoot.getAttachment(org.jboss.as.ee.structure.Attachments.ALTERNATE_CONNECTOR_DEPLOYMENT_DESCRIPTOR);
        VirtualFile serviceXmlFile = alternateDescriptor != null ? alternateDescriptor : file.getChild("/META-INF/ra.xml");
        InputStream xmlStream = null;
        Connector result = null;
        try {
            if (serviceXmlFile != null && serviceXmlFile.exists() && (result = new RaParser().parse(xmlStream = serviceXmlFile.openStream())) == null) {
                throw ConnectorMessages.MESSAGES.failedToParseServiceXml(serviceXmlFile);
            }
            File root = file.getPhysicalFile();
            URL url = root.toURI().toURL();
            String deploymentName = file.getName().substring(0, file.getName().indexOf(".rar"));
            ConnectorXmlDescriptor xmlDescriptor = new ConnectorXmlDescriptor(result, root, url, deploymentName);
            phaseContext.getDeploymentUnit().putAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY, (Object)xmlDescriptor);
        }
        catch (Exception e) {
            try {
                throw ConnectorMessages.MESSAGES.failedToParseServiceXml(e, serviceXmlFile);
            }
            catch (Throwable throwable) {
                VFSUtils.safeClose(xmlStream);
                throw throwable;
            }
        }
        VFSUtils.safeClose((Closeable)xmlStream);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

