/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheException;
import org.infinispan.CacheSupport;
import org.infinispan.DecoratedCache;
import org.infinispan.Version;
import org.infinispan.atomic.Delta;
import org.infinispan.batch.BatchContainer;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.read.ValuesCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationException;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.stats.Stats;
import org.infinispan.stats.StatsImpl;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.AbstractInProcessNotifyingFuture;
import org.infinispan.util.concurrent.DeferredReturnFuture;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.rhq.helpers.pluginAnnotations.agent.DataType;
import org.rhq.helpers.pluginAnnotations.agent.DisplayType;
import org.rhq.helpers.pluginAnnotations.agent.Metric;
import org.rhq.helpers.pluginAnnotations.agent.Operation;

@SurvivesRestarts
@MBean(objectName="Cache", description="Component that represents an individual cache instance.")
public class CacheImpl<K, V>
extends CacheSupport<K, V>
implements AdvancedCache<K, V> {
    public static final String OBJECT_NAME = "Cache";
    protected InvocationContextContainer icc;
    protected CommandsFactory commandsFactory;
    protected InterceptorChain invoker;
    protected Configuration config;
    protected CacheNotifier notifier;
    protected BatchContainer batchContainer;
    protected ComponentRegistry componentRegistry;
    protected TransactionManager transactionManager;
    protected RpcManager rpcManager;
    protected StreamingMarshaller marshaller;
    private final String name;
    private EvictionManager evictionManager;
    private DataContainer dataContainer;
    private static final Log log = LogFactory.getLog(CacheImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private EmbeddedCacheManager cacheManager;
    private StateTransferManager stateTransferManager;
    private ResponseGenerator responseGenerator;
    private LockManager lockManager;
    private DistributionManager distributionManager;
    private ExecutorService asyncExecutor;
    private TransactionTable txTable;
    private RecoveryManager recoveryManager;
    private TransactionCoordinator txCoordinator;

    public CacheImpl(String name) {
        this.name = name;
    }

    @Inject
    public void injectDependencies(EvictionManager evictionManager, InvocationContextContainer icc, CommandsFactory commandsFactory, InterceptorChain interceptorChain, Configuration configuration, CacheNotifier notifier, ComponentRegistry componentRegistry, TransactionManager transactionManager, BatchContainer batchContainer, RpcManager rpcManager, DataContainer dataContainer, @ComponentName(value="org.infinispan.marshaller.cache") StreamingMarshaller marshaller, ResponseGenerator responseGenerator, DistributionManager distributionManager, EmbeddedCacheManager cacheManager, StateTransferManager stateTransferManager, @ComponentName(value="org.infinispan.executors.transport") ExecutorService asyncExecutor, TransactionTable txTable, RecoveryManager recoveryManager, TransactionCoordinator txCoordinator, LockManager lockManager) {
        this.commandsFactory = commandsFactory;
        this.invoker = interceptorChain;
        this.config = configuration;
        this.notifier = notifier;
        this.componentRegistry = componentRegistry;
        this.transactionManager = transactionManager;
        this.batchContainer = batchContainer;
        this.rpcManager = rpcManager;
        this.evictionManager = evictionManager;
        this.dataContainer = dataContainer;
        this.marshaller = marshaller;
        this.cacheManager = cacheManager;
        this.responseGenerator = responseGenerator;
        this.stateTransferManager = stateTransferManager;
        this.icc = icc;
        this.distributionManager = distributionManager;
        this.asyncExecutor = asyncExecutor;
        this.txTable = txTable;
        this.recoveryManager = recoveryManager;
        this.txCoordinator = txCoordinator;
        this.lockManager = lockManager;
    }

    private void assertKeyNotNull(Object key) {
        if (key == null) {
            throw new NullPointerException("Null keys are not supported!");
        }
    }

    private void assertKeysNotNull(Map<?, ?> data) {
        if (data == null) {
            throw new NullPointerException("Expected map cannot be null");
        }
        for (Object key : data.keySet()) {
            if (key != null) continue;
            throw new NullPointerException("Null keys are not supported!");
        }
    }

    public final boolean remove(Object key, Object value) {
        return this.remove(key, value, null, null);
    }

    final boolean remove(Object key, Object value, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, value, ctx.getFlags());
        return (Boolean)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    public final int size() {
        return this.size(null, null);
    }

    final int size(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        SizeCommand command = this.commandsFactory.buildSizeCommand();
        return (Integer)this.invoker.invoke(this.getInvocationContextForRead(null, explicitFlags, explicitClassLoader), command);
    }

    public final boolean isEmpty() {
        return this.size() == 0;
    }

    final boolean isEmpty(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        return this.size(explicitFlags, explicitClassLoader) == 0;
    }

    public final boolean containsKey(Object key) {
        return this.containsKey(key, null, null);
    }

    final boolean containsKey(Object key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextForRead(null, explicitFlags, explicitClassLoader);
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key, ctx.getFlags());
        Object response = this.invoker.invoke(ctx, command);
        return response != null;
    }

    public final boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Not supported");
    }

    public final V get(Object key) {
        return this.get(key, null, null);
    }

    final V get(Object key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextForRead(null, explicitFlags, explicitClassLoader);
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key, ctx.getFlags());
        return (V)this.invoker.invoke(ctx, command);
    }

    public final V remove(Object key) {
        return this.remove(key, null, null);
    }

    final V remove(Object key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, null, ctx.getFlags());
        return (V)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    public final void clear() {
        this.clear(null, null);
    }

    final void clear(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        ClearCommand command = this.commandsFactory.buildClearCommand(ctx.getFlags());
        this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    @Override
    public Set<K> keySet() {
        return this.keySet(null, null);
    }

    Set<K> keySet(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(null, explicitFlags, explicitClassLoader);
        KeySetCommand command = this.commandsFactory.buildKeySetCommand();
        return (Set)this.invoker.invoke(ctx, command);
    }

    @Override
    public Collection<V> values() {
        return this.values(null, null);
    }

    Collection<V> values(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(null, explicitFlags, explicitClassLoader);
        ValuesCommand command = this.commandsFactory.buildValuesCommand();
        return (Collection)this.invoker.invoke(ctx, command);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet(null, null);
    }

    Set<Map.Entry<K, V>> entrySet(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(null, explicitFlags, explicitClassLoader);
        EntrySetCommand command = this.commandsFactory.buildEntrySetCommand();
        return (Set)this.invoker.invoke(ctx, command);
    }

    @Override
    public final void putForExternalRead(K key, V value) {
        this.putForExternalRead(key, value, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void putForExternalRead(K key, V value, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        Transaction ongoingTransaction = null;
        try {
            ongoingTransaction = this.getOngoingTransaction();
            if (ongoingTransaction != null) {
                this.transactionManager.suspend();
            }
            EnumSet<Flag> flags = EnumSet.of(Flag.FAIL_SILENTLY, Flag.FORCE_ASYNCHRONOUS, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.PUT_FOR_EXTERNAL_READ);
            if (explicitFlags != null && !explicitFlags.isEmpty()) {
                flags.addAll(explicitFlags);
            }
            this.putIfAbsent(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS, flags, explicitClassLoader);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught exception while doing putForExternalRead()", e);
            }
        }
        finally {
            block16: {
                try {
                    if (ongoingTransaction != null) {
                        this.transactionManager.resume(ongoingTransaction);
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block16;
                    log.debug("Had problems trying to resume a transaction after putForExternalRead()", e);
                }
            }
        }
    }

    @Override
    public final void evict(K key) {
        this.evict(key, null, null);
    }

    final void evict(K key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.createNonTxInvocationContext(explicitFlags, explicitClassLoader);
        EvictCommand command = this.commandsFactory.buildEvictCommand(key);
        this.invoker.invoke(ctx, command);
    }

    private InvocationContext createNonTxInvocationContext(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        NonTxInvocationContext ctx = this.icc.createNonTxInvocationContext();
        return this.setInvocationContextFlagsAndClassLoader(ctx, explicitFlags, explicitClassLoader);
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public void addListener(Object listener) {
        this.notifier.addListener(listener);
    }

    @Override
    public void removeListener(Object listener) {
        this.notifier.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        return this.notifier.getListeners();
    }

    private InvocationContext getInvocationContextForWrite(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.icc.createInvocationContext(true);
        return this.setInvocationContextFlagsAndClassLoader(ctx, explicitFlags, explicitClassLoader);
    }

    private InvocationContext getInvocationContextForRead(Transaction tx, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        if (this.config.isTransactionalCache()) {
            Transaction transaction;
            Transaction transaction2 = transaction = tx == null ? this.getOngoingTransaction() : tx;
            if (transaction != null) {
                return this.getInvocationContext(transaction, explicitFlags, explicitClassLoader);
            }
        }
        InvocationContext result = this.icc.createInvocationContext(false);
        this.setInvocationContextFlagsAndClassLoader(result, explicitFlags, explicitClassLoader);
        return result;
    }

    private InvocationContext getInvocationContextWithImplicitTransaction(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext invocationContext;
        boolean txInjected = false;
        if (this.config.isTransactionalCache()) {
            Transaction transaction = this.getOngoingTransaction();
            if (transaction == null && this.config.isTransactionAutoCommit()) {
                try {
                    this.transactionManager.begin();
                    transaction = this.transactionManager.getTransaction();
                    txInjected = true;
                    if (trace) {
                        log.trace("Implicit transaction started!");
                    }
                }
                catch (Exception e) {
                    throw new CacheException("Could not start transaction", (Throwable)e);
                }
            }
            invocationContext = this.getInvocationContext(transaction, explicitFlags, explicitClassLoader);
        } else {
            invocationContext = this.getInvocationContextForWrite(explicitFlags, explicitClassLoader);
        }
        if (txInjected) {
            ((TxInvocationContext)invocationContext).setImplicitTransaction(true);
            if (trace) {
                log.tracef("Marked tx as implicit.", new Object[0]);
            }
        }
        return invocationContext;
    }

    private InvocationContext getInvocationContext(Transaction tx, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.icc.createInvocationContext(tx);
        return this.setInvocationContextFlagsAndClassLoader(ctx, explicitFlags, explicitClassLoader);
    }

    private InvocationContext setInvocationContextFlagsAndClassLoader(InvocationContext ctx, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        if (explicitFlags != null) {
            ctx.setFlags(explicitFlags);
        }
        ctx.setClassLoader(explicitClassLoader != null ? explicitClassLoader : this.getClassLoader());
        return ctx;
    }

    @Override
    public boolean lock(K ... keys) {
        this.assertKeyNotNull(keys);
        return this.lock(Arrays.asList(keys), null, null);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return this.lock(keys, null, null);
    }

    boolean lock(Collection<? extends K> keys, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("Cannot lock empty list of keys");
        }
        InvocationContext ctx = this.getInvocationContextForWrite(explicitFlags, explicitClassLoader);
        LockControlCommand command = this.commandsFactory.buildLockControlCommand(keys, ctx.getFlags());
        return (Boolean)this.invoker.invoke(ctx, command);
    }

    @Override
    public void applyDelta(K deltaAwareValueKey, Delta delta, Object ... locksToAcquire) {
        if (locksToAcquire == null || locksToAcquire.length == 0) {
            throw new IllegalArgumentException("Cannot lock empty list of keys");
        }
        InvocationContext ctx = this.getInvocationContextForWrite(null, null);
        ApplyDeltaCommand command = this.commandsFactory.buildApplyDeltaCommand(deltaAwareValueKey, delta, Arrays.asList(locksToAcquire));
        this.invoker.invoke(ctx, command);
    }

    @ManagedOperation(description="Starts the cache.")
    @Operation(displayName="Starts cache.")
    public void start() {
        this.componentRegistry.start();
        this.defaultLifespan = this.config.getExpirationLifespan();
        this.defaultMaxIdleTime = this.config.getExpirationMaxIdle();
        if (log.isDebugEnabled()) {
            log.debugf("Started cache %s on %s", this.getName(), this.getCacheManager().getAddress());
        }
    }

    @ManagedOperation(description="Stops the cache.")
    @Operation(displayName="Stops cache.")
    public void stop() {
        this.stop(null, null);
    }

    void stop(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        if (log.isDebugEnabled()) {
            log.debugf("Stopping cache %s on %s", this.getName(), this.getCacheManager().getAddress());
        }
        this.createNonTxInvocationContext(explicitFlags, explicitClassLoader);
        this.componentRegistry.stop();
    }

    @Override
    public List<CommandInterceptor> getInterceptorChain() {
        return this.invoker.asList();
    }

    @Override
    public void addInterceptor(CommandInterceptor i, int position) {
        this.invoker.addInterceptor(i, position);
    }

    @Override
    public boolean addInterceptorAfter(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        return this.invoker.addInterceptorAfter(i, afterInterceptor);
    }

    @Override
    public boolean addInterceptorBefore(CommandInterceptor i, Class<? extends CommandInterceptor> beforeInterceptor) {
        return this.invoker.addInterceptorBefore(i, beforeInterceptor);
    }

    @Override
    public void removeInterceptor(int position) {
        this.invoker.removeInterceptor(position);
    }

    @Override
    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.invoker.removeInterceptor(interceptorType);
    }

    @Override
    public EvictionManager getEvictionManager() {
        return this.evictionManager;
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.distributionManager;
    }

    @Override
    public ComponentStatus getStatus() {
        return this.componentRegistry.getStatus();
    }

    @ManagedAttribute(description="Returns the cache status")
    @Metric(displayName="Cache status", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheStatus() {
        return this.getStatus().toString();
    }

    @Override
    public boolean startBatch() {
        if (!this.config.isInvocationBatchingEnabled()) {
            throw new ConfigurationException("Invocation batching not enabled in current configuration!  Please use the <invocationBatching /> element.");
        }
        return this.batchContainer.startBatch();
    }

    @Override
    public void endBatch(boolean successful) {
        if (!this.config.isInvocationBatchingEnabled()) {
            throw new ConfigurationException("Invocation batching not enabled in current configuration!  Please use the <invocationBatching /> element.");
        }
        this.batchContainer.endBatch(successful);
    }

    public String getName() {
        return this.name;
    }

    @ManagedAttribute(description="Returns the cache name")
    @Metric(displayName="Cache name", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheName() {
        String name = this.getName().equals("___defaultcache") ? "Default Cache" : this.getName();
        return name + "(" + this.getConfiguration().getCacheModeString().toLowerCase() + ")";
    }

    @ManagedAttribute(description="Returns the cache configuration as XML string")
    @Metric(displayName="Cache configuration (XML)", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getConfigurationAsXmlString() {
        return this.getConfiguration().toXmlString();
    }

    public String getVersion() {
        return Version.VERSION;
    }

    public String toString() {
        return "Cache '" + this.name + "'@" + (this.config.getCacheMode().isClustered() ? this.getCacheManager().getAddress() : Util.hexIdHashCode((Object)this));
    }

    @Override
    public BatchContainer getBatchContainer() {
        return this.batchContainer;
    }

    @Override
    public InvocationContextContainer getInvocationContextContainer() {
        return this.icc;
    }

    @Override
    public DataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public Stats getStats() {
        return new StatsImpl(this.invoker);
    }

    @Override
    public XAResource getXAResource() {
        return new TransactionXaAdapter(this.txTable, this.config, this.recoveryManager, this.txCoordinator, this.commandsFactory, this.rpcManager, null, this.config);
    }

    public final V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        return this.put(key, value, lifespan, lifespanUnit, maxIdleTime, idleTimeUnit, null, null);
    }

    final V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime), ctx.getFlags());
        return (V)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        return this.putIfAbsent(key, value, lifespan, lifespanUnit, maxIdleTime, idleTimeUnit, null, null);
    }

    final V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime), ctx.getFlags());
        command.setPutIfAbsent(true);
        return (V)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        this.putAll(map, lifespan, lifespanUnit, maxIdleTime, idleTimeUnit, null, null);
    }

    final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeysNotNull(map);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        PutMapCommand command = this.commandsFactory.buildPutMapCommand(map, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime), ctx.getFlags());
        this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    public final V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        return this.replace(key, value, lifespan, lifespanUnit, maxIdleTime, idleTimeUnit, null, null);
    }

    final V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, null, value, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime), ctx.getFlags());
        return (V)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        return this.replace(key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, idleTimeUnit, null, null);
    }

    final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, oldValue, value, lifespanUnit.toMillis(lifespan), idleTimeUnit.toMillis(maxIdleTime), ctx.getFlags());
        return (Boolean)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    private <X> NotifyingFuture<X> wrapInFuture(final Object retval) {
        if (retval instanceof NotifyingFuture) {
            return (NotifyingFuture)retval;
        }
        return new AbstractInProcessNotifyingFuture<X>(){

            @Override
            public X get() throws InterruptedException, ExecutionException {
                return retval;
            }
        };
    }

    public final NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.putAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit, null, null);
    }

    final NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        ctx.setUseFutureReturnType(true);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle), ctx.getFlags());
        return this.wrapInFuture(this.executeCommandAndCommitIfNeeded(ctx, command));
    }

    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.putAllAsync(data, lifespan, lifespanUnit, maxIdle, maxIdleUnit, null, null);
    }

    final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeysNotNull(data);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        ctx.setUseFutureReturnType(true);
        PutMapCommand command = this.commandsFactory.buildPutMapCommand(data, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle), ctx.getFlags());
        return this.wrapInFuture(this.executeCommandAndCommitIfNeeded(ctx, command));
    }

    public final NotifyingFuture<Void> clearAsync() {
        return this.clearAsync(null, null);
    }

    final NotifyingFuture<Void> clearAsync(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        ctx.setUseFutureReturnType(true);
        ClearCommand command = this.commandsFactory.buildClearCommand(ctx.getFlags());
        return this.wrapInFuture(this.executeCommandAndCommitIfNeeded(ctx, command));
    }

    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.putIfAbsentAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit, null, null);
    }

    final NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        ctx.setUseFutureReturnType(true);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle), ctx.getFlags());
        command.setPutIfAbsent(true);
        return this.wrapInFuture(this.executeCommandAndCommitIfNeeded(ctx, command));
    }

    public final NotifyingFuture<V> removeAsync(Object key) {
        return this.removeAsync(key, null, null);
    }

    final NotifyingFuture<V> removeAsync(Object key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        ctx.setUseFutureReturnType(true);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, null, ctx.getFlags());
        return this.wrapInFuture(this.executeCommandAndCommitIfNeeded(ctx, command));
    }

    public final NotifyingFuture<Boolean> removeAsync(Object key, Object value) {
        return this.removeAsync(key, value, null, null);
    }

    final NotifyingFuture<Boolean> removeAsync(Object key, Object value, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        ctx.setUseFutureReturnType(true);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, value, ctx.getFlags());
        return this.wrapInFuture(this.executeCommandAndCommitIfNeeded(ctx, command));
    }

    public final NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.replaceAsync(key, value, lifespan, lifespanUnit, maxIdle, maxIdleUnit, null, null);
    }

    final NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        ctx.setUseFutureReturnType(true);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, null, value, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle), ctx.getFlags());
        return this.wrapInFuture(this.executeCommandAndCommitIfNeeded(ctx, command));
    }

    public final NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        return this.replaceAsync(key, oldValue, newValue, lifespan, lifespanUnit, maxIdle, maxIdleUnit, null, null);
    }

    final NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(explicitFlags, explicitClassLoader);
        ctx.setUseFutureReturnType(true);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, oldValue, newValue, lifespanUnit.toMillis(lifespan), maxIdleUnit.toMillis(maxIdle), ctx.getFlags());
        return this.wrapInFuture(this.executeCommandAndCommitIfNeeded(ctx, command));
    }

    public NotifyingFuture<V> getAsync(K key) {
        return this.getAsync(key, null, null);
    }

    NotifyingFuture<V> getAsync(final K key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        Object appliedFlags;
        final Transaction tx = this.getOngoingTransaction();
        DeferredReturnFuture f = new DeferredReturnFuture();
        if (this.asyncSkipsThread(explicitFlags, key)) {
            return this.wrapInFuture(this.get(key, explicitFlags, explicitClassLoader));
        }
        if (explicitFlags == null) {
            appliedFlags = null;
        } else {
            appliedFlags = explicitFlags.clone();
            explicitFlags.clear();
        }
        Callable c = new Callable<V>((EnumSet)appliedFlags, explicitClassLoader, f){
            final /* synthetic */ EnumSet val$appliedFlags;
            final /* synthetic */ ClassLoader val$explicitClassLoader;
            final /* synthetic */ NotifyingNotifiableFuture val$f;
            {
                this.val$appliedFlags = enumSet;
                this.val$explicitClassLoader = classLoader;
                this.val$f = notifyingNotifiableFuture;
            }

            @Override
            public V call() throws Exception {
                CacheImpl.this.assertKeyNotNull(key);
                InvocationContext ctx = CacheImpl.this.getInvocationContextForRead(tx, this.val$appliedFlags, this.val$explicitClassLoader);
                GetKeyValueCommand command = CacheImpl.this.commandsFactory.buildGetKeyValueCommand(key, this.val$appliedFlags);
                Object ret = CacheImpl.this.invoker.invoke(ctx, command);
                this.val$f.notifyDone();
                return ret;
            }
        };
        f.setNetworkFuture(this.asyncExecutor.submit(c));
        return f;
    }

    private boolean asyncSkipsThread(EnumSet<Flag> flags, K key) {
        boolean isSkipLoader = this.isSkipLoader(flags);
        if (!isSkipLoader) {
            return false;
        }
        Configuration.CacheMode cacheMode = this.config.getCacheMode();
        if (!cacheMode.isDistributed()) {
            return true;
        }
        if (flags != null && (flags.contains((Object)Flag.SKIP_REMOTE_LOOKUP) || flags.contains((Object)Flag.CACHE_MODE_LOCAL))) {
            return true;
        }
        return this.distributionManager.getLocality(key).isLocal();
    }

    private boolean isSkipLoader(EnumSet<Flag> flags) {
        boolean hasCacheLoaderConfig = this.config.getCacheLoaderManagerConfig().getFirstCacheLoaderConfig() != null;
        return !hasCacheLoaderConfig || hasCacheLoaderConfig && flags != null && (flags.contains((Object)Flag.SKIP_CACHE_LOAD) || flags.contains((Object)Flag.SKIP_CACHE_STORE));
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public void compact() {
        for (InternalCacheEntry e : this.dataContainer) {
            if (e.getKey() instanceof MarshalledValue) {
                ((MarshalledValue)e.getKey()).compact(true, true);
            }
            if (!(e.getValue() instanceof MarshalledValue)) continue;
            ((MarshalledValue)e.getValue()).compact(true, true);
        }
    }

    @Override
    public RpcManager getRpcManager() {
        return this.rpcManager;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        if (flags == null || flags.length == 0) {
            return this;
        }
        return new DecoratedCache(this, flags);
    }

    private Transaction getOngoingTransaction() {
        try {
            Transaction transaction = null;
            if (this.transactionManager != null && (transaction = this.transactionManager.getTransaction()) == null && this.config.isInvocationBatchingEnabled()) {
                transaction = this.batchContainer.getBatchTransaction();
            }
            return transaction;
        }
        catch (SystemException e) {
            throw new CacheException("Unable to get transaction", (Throwable)e);
        }
    }

    private Object executeCommandAndCommitIfNeeded(InvocationContext ctx, VisitableCommand command) {
        Object result;
        boolean txInjected = ctx.isInTxScope() && ((TxInvocationContext)ctx).isImplicitTransaction();
        try {
            result = this.invoker.invoke(ctx, command);
        }
        catch (RuntimeException e) {
            if (txInjected) {
                this.tryRollback();
            }
            throw e;
        }
        if (txInjected) {
            if (trace) {
                log.tracef("Committing transaction as it was implicit: %s", this.getOngoingTransaction());
            }
            try {
                this.transactionManager.commit();
            }
            catch (Throwable e) {
                log.couldNotCompleteInjectedTransaction(e);
                this.tryRollback();
                throw new CacheException("Could not commit implicit transaction", e);
            }
        }
        return result;
    }

    private void tryRollback() {
        block3: {
            try {
                if (this.transactionManager != null) {
                    this.transactionManager.rollback();
                }
            }
            catch (Throwable t) {
                if (!trace) break block3;
                log.trace("Could not rollback", t);
            }
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.config.getClassLoader();
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        return new DecoratedCache(this, classLoader);
    }

    protected void set(K key, V value) {
        this.withFlags(Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD).put(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }
}

