/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.control;

import java.util.List;
import java.util.Map;
import org.infinispan.CacheException;
import org.infinispan.cacheviews.CacheView;
import org.infinispan.cacheviews.CacheViewsManager;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheViewControlCommand
implements CacheRpcCommand {
    private static final Log log = LogFactory.getLog(CacheViewControlCommand.class);
    public static final int COMMAND_ID = 17;
    private CacheViewsManager cacheViewsManager;
    private final String cacheName;
    private Type type;
    private Address sender;
    private int newViewId;
    private List<Address> newMembers;
    private int oldViewId;
    private List<Address> oldMembers;

    public CacheViewControlCommand() {
        this.cacheName = null;
    }

    public CacheViewControlCommand(String cacheName) {
        this.cacheName = cacheName;
    }

    public CacheViewControlCommand(String cacheName, Type type, Address sender, int newViewId, List<Address> newMembers, int oldViewId, List<Address> oldMembers) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.newViewId = newViewId;
        this.newMembers = newMembers;
        this.oldViewId = oldViewId;
        this.oldMembers = oldMembers;
    }

    public CacheViewControlCommand(String cacheName, Type type, Address sender, int viewId) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
        this.newViewId = viewId;
    }

    public CacheViewControlCommand(String cacheName, Type type, Address sender) {
        this.cacheName = cacheName;
        this.type = type;
        this.sender = sender;
    }

    public void init(CacheViewsManager cacheViewsManager) {
        this.cacheViewsManager = cacheViewsManager;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(this.cacheName, trace);
        try {
            switch (this.type) {
                case REQUEST_JOIN: {
                    this.cacheViewsManager.handleRequestJoin(this.sender, this.cacheName);
                    Object var3_3 = null;
                    return var3_3;
                }
                case REQUEST_LEAVE: {
                    this.cacheViewsManager.handleRequestLeave(this.sender, this.cacheName);
                    Object var3_4 = null;
                    return var3_4;
                }
                case PREPARE_VIEW: {
                    this.cacheViewsManager.handlePrepareView(this.cacheName, new CacheView(this.newViewId, this.newMembers), new CacheView(this.oldViewId, this.oldMembers));
                    Object var3_5 = null;
                    return var3_5;
                }
                case COMMIT_VIEW: {
                    this.cacheViewsManager.handleCommitView(this.cacheName, this.newViewId);
                    Object var3_6 = null;
                    return var3_6;
                }
                case ROLLBACK_VIEW: {
                    this.cacheViewsManager.handleRollbackView(this.cacheName, this.newViewId, this.oldViewId);
                    Object var3_7 = null;
                    return var3_7;
                }
                case RECOVER_VIEW: {
                    Map<String, CacheView> map = this.cacheViewsManager.handleRecoverViews();
                    return map;
                }
            }
            try {
                throw new CacheException("Unknown cache views control command type " + (Object)((Object)this.type));
            }
            catch (Throwable t) {
                log.exceptionHandlingCommand(this, t);
                throw t;
            }
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public void injectComponents(Configuration cfg, ComponentRegistry cr) {
    }

    @Override
    public Configuration getConfiguration() {
        return null;
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
        this.sender = origin;
    }

    @Override
    public Address getOrigin() {
        return this.sender;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public byte getCommandId() {
        return 17;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{(byte)this.type.ordinal(), this.sender, this.newViewId, this.newMembers, this.oldViewId, this.oldMembers};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        int i = 0;
        this.type = Type.values()[(Byte)parameters[i++]];
        this.sender = (Address)parameters[i++];
        this.newViewId = (Integer)parameters[i++];
        this.newMembers = (List)parameters[i++];
        this.oldViewId = (Integer)parameters[i++];
        this.oldMembers = (List)parameters[i++];
    }

    public String toString() {
        return "CacheViewControlCommand{cache=" + this.cacheName + ", type=" + (Object)((Object)this.type) + ", sender=" + this.sender + ", newViewId=" + this.newViewId + ", newMembers=" + this.newMembers + ", oldViewId=" + this.oldViewId + ", oldMembers=" + this.oldMembers + '}';
    }

    public static enum Type {
        REQUEST_JOIN,
        REQUEST_LEAVE,
        PREPARE_VIEW,
        COMMIT_VIEW,
        ROLLBACK_VIEW,
        RECOVER_VIEW;

    }
}

