/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.util.concurrent.FutureListener;
import org.infinispan.util.concurrent.NotifyingFuture;

public class DistributedExecutionCompletionService<V>
implements CompletionService<V> {
    protected final DistributedExecutorService executor;
    protected final BlockingQueue<NotifyingFuture<V>> completionQueue;
    protected final QueueingListener listener;

    public DistributedExecutionCompletionService(DistributedExecutorService executor) {
        this(executor, null, null);
    }

    public DistributedExecutionCompletionService(DistributedExecutorService executor, BlockingQueue<NotifyingFuture<V>> completionQueue) {
        this(executor, completionQueue, null);
    }

    protected DistributedExecutionCompletionService(DistributedExecutorService executor, BlockingQueue<NotifyingFuture<V>> completionQueue, QueueingListener listener) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = completionQueue == null ? new LinkedBlockingQueue<NotifyingFuture<V>>() : completionQueue;
        this.listener = listener == null ? new QueueingListener() : listener;
    }

    @Override
    public Future<V> submit(Callable<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        NotifyingFuture f = (NotifyingFuture)this.executor.submit(task);
        f.attachListener((FutureListener)this.listener);
        return f;
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        if (task == null) {
            throw new NullPointerException();
        }
        NotifyingFuture f = (NotifyingFuture)this.executor.submit(task, result);
        f.attachListener((FutureListener)this.listener);
        return f;
    }

    @Override
    public NotifyingFuture<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    @Override
    public NotifyingFuture<V> poll() {
        return (NotifyingFuture)this.completionQueue.poll();
    }

    @Override
    public NotifyingFuture<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completionQueue.poll(timeout, unit);
    }

    protected class QueueingListener
    implements FutureListener<V> {
        protected QueueingListener() {
        }

        public void futureDone(Future<V> future) {
            DistributedExecutionCompletionService.this.completionQueue.add((NotifyingFuture)future);
        }
    }
}

