/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.CacheException;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.NamedComponentFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.marshall.AbstractDelegatingMarshaller;
import org.infinispan.marshall.CacheMarshaller;
import org.infinispan.marshall.GlobalMarshaller;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.marshall.VersionAwareMarshaller;
import org.infinispan.util.Util;

@DefaultFactoryFor(classes={StreamingMarshaller.class, Marshaller.class})
public class MarshallerFactory
extends NamedComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType, String componentName) {
        AbstractDelegatingMarshaller comp;
        if (componentName.equals("org.infinispan.marshaller.global")) {
            comp = new GlobalMarshaller(this.createMarshaller());
        } else if (componentName.equals("org.infinispan.marshaller.cache")) {
            comp = new CacheMarshaller(this.createMarshaller());
        } else {
            throw new CacheException("Don't know how to handle type " + componentType);
        }
        try {
            return componentType.cast(comp);
        }
        catch (Exception e) {
            throw new CacheException("Problems casting bootstrap component " + comp.getClass() + " to type " + componentType, (Throwable)e);
        }
    }

    protected VersionAwareMarshaller createMarshaller() {
        return (VersionAwareMarshaller)((Object)Util.getInstance((String)this.globalConfiguration.getMarshallerClass(), (ClassLoader)this.globalConfiguration.getClassLoader()));
    }
}

