/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.concurrent.NotifyingFutureImpl;

public class ReplicationInterceptor
extends BaseRpcInterceptor {
    private StateTransferLock stateTransferLock;
    private CommandsFactory cf;

    @Inject
    public void init(StateTransferLock stateTransferLock, CommandsFactory cf) {
        this.stateTransferLock = stateTransferLock;
        this.cf = cf;
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!ctx.isInTxScope()) {
            throw new IllegalStateException("This should not be possible!");
        }
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            this.stateTransferLock.waitForStateTransferToEnd(ctx, command, -1);
            this.sendCommitCommand(ctx, command);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private boolean needToResendPrepare(Response r) {
        return r instanceof SuccessfulResponse && Byte.valueOf((byte)1).equals(((SuccessfulResponse)r).getResponseValue());
    }

    private void sendCommitCommand(TxInvocationContext ctx, CommitCommand command) throws TimeoutException, InterruptedException {
        Map<Address, Response> responses = this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, this.configuration.isSyncCommitPhase(), true);
        if (!responses.isEmpty()) {
            LinkedList<Address> resendTo = new LinkedList<Address>();
            for (Map.Entry<Address, Response> r : responses.entrySet()) {
                if (!this.needToResendPrepare(r.getValue())) continue;
                resendTo.add(r.getKey());
            }
            if (!resendTo.isEmpty()) {
                this.log.debugf("Need to resend prepares for %s to %s", command.getGlobalTransaction(), resendTo);
                PrepareCommand pc = this.cf.buildPrepareCommand(command.getGlobalTransaction(), ctx.getModifications(), true);
                this.rpcManager.invokeRemotely(resendTo, (ReplicableCommand)pc, true, true);
            }
        }
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            this.stateTransferLock.waitForStateTransferToEnd(ctx, command, -1);
            boolean async = this.configuration.getCacheMode() == Configuration.CacheMode.REPL_ASYNC;
            this.rpcManager.broadcastRpcCommand(command, !async, false);
        }
        return retVal;
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx) && !this.configuration.isOnePhaseCommit()) {
            this.rpcManager.broadcastRpcCommand(command, this.configuration.isSyncRollbackPhase(), true);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleCrudMethod(ctx, command);
    }

    private Object handleCrudMethod(InvocationContext ctx, WriteCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        this.populateCommandFlags(command, ctx);
        if (!this.isLocalModeForced(ctx) && command.isSuccessful() && ctx.isOriginLocal() && !ctx.isInTxScope()) {
            this.stateTransferLock.waitForStateTransferToEnd(ctx, command, -1);
            if (ctx.isUseFutureReturnType()) {
                NotifyingFutureImpl future = new NotifyingFutureImpl(returnValue);
                this.rpcManager.broadcastRpcCommandInFuture(command, future);
                return future;
            }
            this.rpcManager.broadcastRpcCommand(command, this.isSynchronous(ctx));
        }
        return returnValue;
    }

    private void populateCommandFlags(WriteCommand command, InvocationContext ctx) {
        command.setFlags(ctx.getFlags());
    }
}

