/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.marshall.AdvancedExternalizer;
import org.infinispan.remoting.transport.TopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.jgroups.Address;
import org.jgroups.util.TopologyUUID;
import org.jgroups.util.Util;

public class JGroupsTopologyAwareAddress
extends JGroupsAddress
implements TopologyAwareAddress {
    public JGroupsTopologyAwareAddress(Address address) {
        super(address);
    }

    @Override
    public String getSiteId() {
        return ((TopologyUUID)this.getJGroupsAddress()).getSiteId();
    }

    @Override
    public String getRackId() {
        return ((TopologyUUID)this.getJGroupsAddress()).getRackId();
    }

    @Override
    public String getMachineId() {
        return ((TopologyUUID)this.getJGroupsAddress()).getMachineId();
    }

    @Override
    public boolean isSameSite(TopologyAwareAddress addr) {
        return this.getSiteId() == null ? addr.getSiteId() == null : this.getSiteId().equals(addr.getSiteId());
    }

    @Override
    public boolean isSameRack(TopologyAwareAddress addr) {
        if (!this.isSameSite(addr)) {
            return false;
        }
        return this.getRackId() == null ? addr.getRackId() == null : this.getRackId().equals(addr.getRackId());
    }

    @Override
    public boolean isSameMachine(TopologyAwareAddress addr) {
        if (!this.isSameSite(addr) || !this.isSameRack(addr)) {
            return false;
        }
        return this.getMachineId() == null ? addr.getMachineId() == null : this.getMachineId().equals(addr.getMachineId());
    }

    public static class Externalizer
    implements AdvancedExternalizer<JGroupsTopologyAwareAddress> {
        public void writeObject(ObjectOutput output, JGroupsTopologyAwareAddress address) throws IOException {
            try {
                Util.writeAddress((Address)address.address, (DataOutput)output);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public JGroupsTopologyAwareAddress readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            try {
                Address jgroupsAddress = Util.readAddress((DataInput)unmarshaller);
                JGroupsTopologyAwareAddress address = new JGroupsTopologyAwareAddress(jgroupsAddress);
                return address;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public Set<Class<? extends JGroupsTopologyAwareAddress>> getTypeClasses() {
            return Collections.singleton(JGroupsTopologyAwareAddress.class);
        }

        public Integer getId() {
            return 60;
        }
    }
}

