/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.BidirectionalLinkedHashMap;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractCacheTransaction
implements CacheTransaction {
    protected final GlobalTransaction tx;
    private static Log log = LogFactory.getLog(AbstractCacheTransaction.class);
    private static final int INITIAL_LOCK_CAPACITY = 4;
    protected List<WriteCommand> modifications;
    protected BidirectionalLinkedHashMap<Object, CacheEntry> lookedUpEntries;
    protected Set<Object> affectedKeys = null;
    protected Set<Object> lockedKeys;
    protected Set<Object> backupKeyLocks = null;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    protected volatile boolean prepared;
    protected Integer viewId;

    public AbstractCacheTransaction(GlobalTransaction tx) {
        this.tx = tx;
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.tx;
    }

    @Override
    public List<WriteCommand> getModifications() {
        return this.modifications;
    }

    public void setModifications(WriteCommand[] modifications) {
        this.modifications = Arrays.asList(modifications);
    }

    @Override
    public BidirectionalMap<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries;
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        if (this.lookedUpEntries == null) {
            return null;
        }
        return this.lookedUpEntries.get(key);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        if (this.lookedUpEntries != null) {
            this.lookedUpEntries.remove(key);
        }
    }

    @Override
    public void clearLookedUpEntries() {
        this.lookedUpEntries = null;
    }

    @Override
    public boolean ownsLock(Object key) {
        return this.getLockedKeys().contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnTransactionFinished() {
        log.tracef("transaction %s finished, notifying listening threads.", this.tx);
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForLockRelease(Object key, long lockAcquisitionTimeout) throws InterruptedException {
        this.lock.lock();
        try {
            boolean potentiallyLocked = this.hasLockOrIsLockBackup(key);
            log.tracef("Transaction gtx=%s potentially locks key %s? %s", this.tx, key, potentiallyLocked);
            boolean bl = !potentiallyLocked || this.condition.await(lockAcquisitionTimeout, TimeUnit.MILLISECONDS);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Integer getViewId() {
        return this.viewId;
    }

    @Override
    public void setViewId(Integer viewId) {
        this.viewId = viewId;
    }

    @Override
    public void addBackupLockForKey(Object key) {
        if (this.backupKeyLocks == null) {
            this.backupKeyLocks = new HashSet<Object>(4);
        }
        this.backupKeyLocks.add(key);
    }

    public void registerLockedKey(Object key) {
        if (this.lockedKeys == null) {
            this.lockedKeys = new HashSet<Object>(4);
        }
        log.tracef("Registering locked key: %s", key);
        this.lockedKeys.add(key);
    }

    public Set<Object> getLockedKeys() {
        return this.lockedKeys == null ? Collections.emptySet() : this.lockedKeys;
    }

    @Override
    public void clearLockedKeys() {
        log.tracef("Clearing locked keys: %s", this.lockedKeys);
        this.lockedKeys = null;
    }

    private boolean hasLockOrIsLockBackup(Object key) {
        return this.backupKeyLocks != null && this.backupKeyLocks.contains(key) || this.lockedKeys != null && this.lockedKeys.contains(key);
    }

    public Set<Object> getAffectedKeys() {
        return this.affectedKeys == null ? Collections.emptySet() : this.affectedKeys;
    }

    public void addAffectedKey(Object key) {
        this.initAffectedKeys();
        this.affectedKeys.add(key);
    }

    public void addAllAffectedKeys(Collection<Object> keys) {
        this.initAffectedKeys();
        this.affectedKeys.addAll(keys);
    }

    private void initAffectedKeys() {
        if (this.affectedKeys == null) {
            this.affectedKeys = new HashSet<Object>(4);
        }
    }
}

