/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.as.cmp.component.CmpEntityBeanComponent;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.logging.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TxUtils;

public class TransactionEntityMap
implements Service<TransactionEntityMap> {
    private static final Logger log = Logger.getLogger(TransactionEntityMap.class);
    private final InjectedValue<TransactionManager> transactionManager = new InjectedValue();
    private TransactionLocal txSynch;
    public static final TxAssociation NONE = new TxAssociation(){

        @Override
        public void scheduleSync(Transaction tx, CmpEntityBeanContext context) throws SystemException, RollbackException {
            context.getComponent().getTransactionEntityMap().associate(tx, context);
            context.setTxAssociation(SYNC_SCHEDULED);
        }

        @Override
        public void synchronize(Thread thread, Transaction tx, CmpEntityBeanContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void invokeEjbStore(Thread thread, CmpEntityBeanContext context) {
            throw new UnsupportedOperationException();
        }
    };
    public static final TxAssociation SYNC_SCHEDULED = new TxAssociation(){

        @Override
        public void scheduleSync(Transaction tx, CmpEntityBeanContext context) {
        }

        @Override
        public void invokeEjbStore(Thread thread, CmpEntityBeanContext context) throws Exception {
            if (!context.isRemoved() && context.getPrimaryKey() != null) {
                CmpEntityBeanComponent container = context.getComponent();
                container.invokeEjbStore(context);
            }
        }

        @Override
        public void synchronize(Thread thread, Transaction tx, CmpEntityBeanContext context) throws Exception {
            if (!context.isRemoved() && context.getPrimaryKey() != null) {
                CmpEntityBeanComponent container = context.getComponent();
                container.storeEntity(context);
                context.setTxAssociation(SYNCHRONIZED);
            }
        }
    };
    public static final TxAssociation SYNCHRONIZED = new TxAssociation(){

        @Override
        public void scheduleSync(Transaction tx, CmpEntityBeanContext context) {
            context.setTxAssociation(SYNC_SCHEDULED);
        }

        @Override
        public void invokeEjbStore(Thread thread, CmpEntityBeanContext context) {
        }

        @Override
        public void synchronize(Thread thread, Transaction tx, CmpEntityBeanContext context) {
        }
    };
    public static final TxAssociation PREVENT_SYNC = new TxAssociation(){

        @Override
        public void scheduleSync(Transaction tx, CmpEntityBeanContext context) {
        }

        @Override
        public void synchronize(Thread thread, Transaction tx, CmpEntityBeanContext context) throws Exception {
            CmpEntityBeanComponent container = context.getComponent();
            if (container.getStoreManager().isStoreRequired(context)) {
                throw new EJBException("The instance of " + container.getComponentName() + " with pk=" + context.getPrimaryKey() + " was not stored to prevent potential inconsistency of data in the database:" + " the instance was evicted from the cache during the transaction" + " and the database was possibly updated by another process.");
            }
        }

        @Override
        public void invokeEjbStore(Thread thread, CmpEntityBeanContext context) throws Exception {
            SYNC_SCHEDULED.invokeEjbStore(thread, context);
        }
    };
    public static final TxAssociation NOT_READY = new TxAssociation(){

        @Override
        public void scheduleSync(Transaction tx, CmpEntityBeanContext context) {
        }

        @Override
        public void synchronize(Thread thread, Transaction tx, CmpEntityBeanContext context) throws Exception {
        }

        @Override
        public void invokeEjbStore(Thread thread, CmpEntityBeanContext context) throws Exception {
        }
    };

    public synchronized void start(StartContext context) throws StartException {
        this.txSynch = new TransactionLocal((TransactionManager)this.transactionManager.getValue()){

            public Transaction getTransaction() {
                try {
                    return this.transactionManager.getTransaction();
                }
                catch (SystemException e) {
                    throw new IllegalStateException("An error occured while getting the transaction associated with the current thread: " + (Object)((Object)e));
                }
            }
        };
    }

    public synchronized void stop(StopContext context) {
        this.txSynch = null;
    }

    public synchronized TransactionEntityMap getValue() throws IllegalStateException, IllegalArgumentException {
        if (this.txSynch == null) {
            throw new IllegalStateException("No transaction sync");
        }
        return this;
    }

    public Injector<TransactionManager> getTransactionManagerInjector() {
        return this.transactionManager;
    }

    public void synchronizeEntities(Transaction tx) {
        GlobalTxSynchronization globalSync = (GlobalTxSynchronization)this.txSynch.get(tx);
        if (globalSync != null) {
            globalSync.synchronize();
        }
    }

    public GlobalTxSynchronization getGlobalSynchronization(Transaction tx) throws RollbackException, SystemException {
        GlobalTxSynchronization globalSync = (GlobalTxSynchronization)this.txSynch.get(tx);
        if (globalSync == null) {
            globalSync = new GlobalTxSynchronization(tx);
            this.txSynch.set(tx, (Object)globalSync);
        }
        return globalSync;
    }

    public Transaction getTransaction() {
        return this.txSynch.getTransaction();
    }

    private void associate(Transaction tx, CmpEntityBeanContext context) throws RollbackException, SystemException {
        GlobalTxSynchronization globalSync = this.getGlobalSynchronization(tx);
        globalSync.associate(context);
    }

    public static class GlobalTxSynchronization {
        private Transaction tx;
        private List<CmpEntityBeanContext> instances = new ArrayList<CmpEntityBeanContext>();
        private boolean synchronizing;
        private List<Synchronization> otherSync = Collections.emptyList();
        private Map<Object, Object> txLocals = Collections.emptyMap();

        public GlobalTxSynchronization(Transaction tx) {
            this.tx = tx;
        }

        public void associate(CmpEntityBeanContext context) {
            this.instances.add(context);
        }

        public void synchronize() {
            if (this.synchronizing || this.instances.isEmpty()) {
                return;
            }
            this.synchronizing = true;
            Thread currentThread = Thread.currentThread();
            CmpEntityBeanContext context = null;
            try {
                for (CmpEntityBeanContext instance : this.instances) {
                    if (TxUtils.isRollback((Transaction)this.tx)) {
                        return;
                    }
                    context = instance;
                    context.getTxAssociation().invokeEjbStore(currentThread, context);
                }
                for (CmpEntityBeanContext instance : this.instances) {
                    if (TxUtils.isRollback((Transaction)this.tx)) {
                        return;
                    }
                    context = instance;
                    context.getTxAssociation().synchronize(currentThread, this.tx, context);
                }
            }
            catch (Exception causeByException) {
                try {
                    this.tx.setRollbackOnly();
                }
                catch (Exception e) {
                    log.warn((Object)("Exception while trying to rollback tx: " + this.tx), (Throwable)e);
                }
                if (causeByException instanceof EJBException) {
                    throw (EJBException)((Object)causeByException);
                }
                throw new EJBException("Exception in store of entity:" + (context == null || context.getPrimaryKey() == null ? "<null>" : context.getPrimaryKey().toString()), causeByException);
            }
            finally {
                this.synchronizing = false;
            }
        }
    }

    public static interface TxAssociation {
        public void scheduleSync(Transaction var1, CmpEntityBeanContext var2) throws SystemException, RollbackException;

        public void synchronize(Thread var1, Transaction var2, CmpEntityBeanContext var3) throws Exception;

        public void invokeEjbStore(Thread var1, CmpEntityBeanContext var2) throws Exception;
    }
}

