/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.jdbc2.bridge;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.RemoveException;
import javax.sql.DataSource;
import org.jboss.as.cmp.bridge.FieldBridge;
import org.jboss.as.cmp.component.CmpEntityBeanComponent;
import org.jboss.as.cmp.context.CmpEntityBeanContext;
import org.jboss.as.cmp.jdbc.JDBCEntityPersistenceStore;
import org.jboss.as.cmp.jdbc.SQLUtil;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractCMRFieldBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCAbstractEntityBridge;
import org.jboss.as.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.as.cmp.jdbc.metadata.JDBCCMPFieldMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCEntityMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCOptimisticLockingMetaData;
import org.jboss.as.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.as.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.as.cmp.jdbc2.PersistentContext;
import org.jboss.as.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
import org.jboss.as.cmp.jdbc2.bridge.JDBCCMRFieldBridge2;
import org.jboss.as.cmp.jdbc2.schema.EntityTable;
import org.jboss.as.ejb3.component.entity.EntityBeanComponentInstance;
import org.jboss.logging.Logger;

public class JDBCEntityBridge2
implements JDBCAbstractEntityBridge {
    private final JDBCStoreManager2 manager;
    private final JDBCEntityMetaData metadata;
    private final EntityTable table;
    private final String tableName;
    private final String qualifiedTableName;
    private final Logger log;
    private JDBCCMPFieldBridge2[] pkFields;
    private JDBCCMPFieldBridge2[] cmpFields;
    private JDBCCMPFieldBridge2[] tableFields;
    private JDBCCMRFieldBridge2[] cmrFields;
    private JDBCCMPFieldBridge2 versionField;
    private int cmrCount;

    public JDBCEntityBridge2(JDBCStoreManager2 manager, JDBCEntityMetaData metadata) {
        this.manager = manager;
        this.metadata = metadata;
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + metadata.getName()));
        this.table = manager.getSchema().createEntityTable(metadata, this);
        this.tableName = SQLUtil.getTableNameWithoutSchema(metadata.getDefaultTableName());
        this.qualifiedTableName = SQLUtil.fixTableName(metadata.getDefaultTableName(), this.table.getDataSource());
    }

    public void init() {
        this.loadCMPFields(this.metadata);
        this.loadCMRFields(this.metadata);
        JDBCOptimisticLockingMetaData olMD = this.metadata.getOptimisticLocking();
        if (olMD != null) {
            if (olMD.getLockingStrategy() != JDBCOptimisticLockingMetaData.LockingStrategy.VERSION_COLUMN_STRATEGY) {
                throw new RuntimeException("Only version-column optimistic locking strategy is supported at the moment.");
            }
            JDBCCMPFieldMetaData versionMD = olMD.getLockingField();
            this.versionField = (JDBCCMPFieldBridge2)this.getFieldByName(versionMD.getFieldName());
        }
    }

    public JDBCCMPFieldBridge2 getVersionField() {
        return this.versionField;
    }

    public void resolveRelationships() {
        for (int i = 0; i < this.cmrFields.length; ++i) {
            this.cmrFields[i].resolveRelationship();
        }
    }

    public void start() {
        if (this.versionField != null) {
            this.versionField.initVersion();
        }
        this.table.start();
        if (this.cmrFields != null) {
            for (int i = 0; i < this.cmrFields.length; ++i) {
                this.cmrFields[i].initLoader();
            }
        }
    }

    @Override
    public JDBCEntityMetaData getMetaData() {
        return this.metadata;
    }

    public EntityTable getTable() {
        return this.table;
    }

    @Override
    public JDBCFieldBridge[] getPrimaryKeyFields() {
        return this.pkFields;
    }

    @Override
    public JDBCFieldBridge[] getTableFields() {
        return this.tableFields;
    }

    @Override
    public JDBCAbstractCMRFieldBridge[] getCMRFields() {
        return this.cmrFields;
    }

    @Override
    public JDBCEntityPersistenceStore getManager() {
        return this.manager;
    }

    public CmpEntityBeanComponent getComponent() {
        return this.manager.getComponent();
    }

    public Object extractPrimaryKeyFromInstance(CmpEntityBeanContext ctx) {
        try {
            Object pk = null;
            for (int i = 0; i < this.pkFields.length; ++i) {
                JDBCCMPFieldBridge2 pkField = this.pkFields[i];
                Object fieldValue = pkField.getValue(ctx);
                pk = pkField.setPrimaryKeyValue(pk, fieldValue);
            }
            return pk;
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Internal error extracting primary key from instance", e);
        }
    }

    public static void destroyPersistenceContext(CmpEntityBeanContext ctx) {
        EntityBeanComponentInstance instance = ctx.getComponent().getCache().get(ctx.getPrimaryKey());
        ctx.setPersistenceContext(null);
    }

    public void initPersistenceContext(CmpEntityBeanContext ctx) {
        EntityBeanComponentInstance instance = ctx.getComponent().getCache().get(ctx.getPrimaryKey());
    }

    public void initInstance(CmpEntityBeanContext ctx) {
        int i;
        ctx.setPersistenceContext(new PersistentContext(this, this.table.getRow(ctx.getPrimaryKey())));
        for (i = 0; i < this.tableFields.length; ++i) {
            this.tableFields[i].initInstance(ctx);
        }
        for (i = 0; i < this.cmrFields.length; ++i) {
            this.cmrFields[i].initInstance(ctx);
        }
    }

    @Override
    public List<FieldBridge> getFields() {
        int i;
        ArrayList<FieldBridge> fields = new ArrayList<FieldBridge>();
        for (i = 0; i < this.pkFields.length; ++i) {
            fields.add(this.pkFields[i]);
        }
        for (i = 0; i < this.cmpFields.length; ++i) {
            fields.add(this.cmpFields[i]);
        }
        for (i = 0; i < this.cmrFields.length; ++i) {
            fields.add(this.cmrFields[i]);
        }
        return fields;
    }

    public boolean isStoreRequired(CmpEntityBeanContext instance) {
        PersistentContext pctx = (PersistentContext)instance.getPersistenceContext();
        return pctx.isDirty();
    }

    public boolean isModified(CmpEntityBeanContext instance) {
        PersistentContext pctx = (PersistentContext)instance.getPersistenceContext();
        boolean modified = pctx.isDirty();
        if (!modified && this.cmrFields != null) {
            for (int i = 0; i < this.cmrFields.length; ++i) {
                JDBCCMRFieldBridge2.FieldState cmrState = pctx.getCMRState(i);
                if (cmrState == null || !cmrState.isModified()) continue;
                modified = true;
                break;
            }
        }
        return modified;
    }

    public Class getPrimaryKeyClass() {
        return this.metadata.getPrimaryKeyClass();
    }

    public Class getHomeClass() {
        return this.metadata.getHomeClass();
    }

    public Class getLocalHomeClass() {
        return this.metadata.getLocalHomeClass();
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getQualifiedTableName() {
        return this.qualifiedTableName;
    }

    @Override
    public DataSource getDataSource() {
        return this.table.getDataSource();
    }

    @Override
    public boolean[] getLoadGroupMask(String eagerLoadGroupName) {
        throw new UnsupportedOperationException();
    }

    public int getNextCMRIndex() {
        return this.cmrCount++;
    }

    public void remove(CmpEntityBeanContext ctx) throws RemoveException {
        if (this.cmrFields != null) {
            for (int i = 0; i < this.cmrFields.length; ++i) {
                this.cmrFields[i].remove(ctx);
            }
        }
    }

    @Override
    public String getEntityName() {
        return this.metadata.getName();
    }

    @Override
    public String getAbstractSchemaName() {
        return this.metadata.getAbstractSchemaName();
    }

    @Override
    public FieldBridge getFieldByName(String fieldName) {
        JDBCFieldBridge field;
        int i;
        for (i = 0; i < this.pkFields.length; ++i) {
            field = this.pkFields[i];
            if (!field.getFieldName().equals(fieldName)) continue;
            return field;
        }
        for (i = 0; i < this.cmpFields.length; ++i) {
            field = this.cmpFields[i];
            if (!field.getFieldName().equals(fieldName)) continue;
            return field;
        }
        for (i = 0; i < this.cmrFields.length; ++i) {
            field = this.cmrFields[i];
            if (!field.getFieldName().equals(fieldName)) continue;
            return field;
        }
        throw new IllegalStateException("Field " + fieldName + " not found in entity " + this.getEntityName());
    }

    public Class getRemoteInterface() {
        return this.metadata.getRemoteClass();
    }

    public Class getLocalInterface() {
        return this.metadata.getLocalClass();
    }

    JDBCCMPFieldBridge2 addTableField(JDBCCMPFieldMetaData metadata) {
        JDBCCMPFieldBridge2 cmpField;
        this.table.addField();
        if (this.tableFields == null) {
            this.tableFields = new JDBCCMPFieldBridge2[1];
        } else {
            JDBCCMPFieldBridge2[] tmp = this.tableFields;
            this.tableFields = new JDBCCMPFieldBridge2[this.tableFields.length + 1];
            System.arraycopy(tmp, 0, this.tableFields, 0, tmp.length);
        }
        int tableIndex = this.tableFields.length - 1;
        this.tableFields[this.tableFields.length - 1] = cmpField = new JDBCCMPFieldBridge2(this.manager, this, metadata, tableIndex);
        return cmpField;
    }

    private void loadCMPFields(JDBCEntityMetaData metadata) {
        ArrayList<JDBCCMPFieldBridge2> cmpFieldsList = new ArrayList<JDBCCMPFieldBridge2>(metadata.getCMPFields().size());
        ArrayList<JDBCCMPFieldBridge2> pkFieldsList = new ArrayList<JDBCCMPFieldBridge2>(metadata.getCMPFields().size());
        for (JDBCCMPFieldMetaData cmpFieldMetaData : metadata.getCMPFields()) {
            JDBCCMPFieldBridge2 cmpField = this.addTableField(cmpFieldMetaData);
            if (cmpFieldMetaData.isPrimaryKeyMember()) {
                pkFieldsList.add(cmpField);
                continue;
            }
            cmpFieldsList.add(cmpField);
        }
        this.pkFields = new JDBCCMPFieldBridge2[pkFieldsList.size()];
        for (int i = 0; i < pkFieldsList.size(); ++i) {
            this.pkFields[i] = (JDBCCMPFieldBridge2)pkFieldsList.get(i);
        }
        this.cmpFields = new JDBCCMPFieldBridge2[metadata.getCMPFields().size() - this.pkFields.length];
        int cmpFieldIndex = 0;
        for (int i = 0; i < cmpFieldsList.size(); ++i) {
            this.cmpFields[cmpFieldIndex++] = (JDBCCMPFieldBridge2)cmpFieldsList.get(i);
        }
    }

    private void loadCMRFields(JDBCEntityMetaData metadata) {
        this.cmrFields = new JDBCCMRFieldBridge2[metadata.getRelationshipRoles().size()];
        int cmrFieldIndex = 0;
        for (JDBCRelationshipRoleMetaData relationshipRole : metadata.getRelationshipRoles()) {
            JDBCCMRFieldBridge2 cmrField = new JDBCCMRFieldBridge2(this, this.manager, relationshipRole);
            this.cmrFields[cmrFieldIndex++] = cmrField;
        }
    }

    public void stop() throws Exception {
        this.table.stop();
    }
}

