/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.rmi;

import org.jboss.as.jacorb.rmi.AbstractAnalysis;
import org.jboss.as.jacorb.rmi.RMIIIOPViolationException;
import org.jboss.as.jacorb.rmi.Util;
import org.jboss.logging.Logger;
import org.omg.CORBA.ParameterMode;

public class ParameterAnalysis
extends AbstractAnalysis {
    private static final Logger logger = Logger.getLogger(ParameterAnalysis.class);
    private final Class cls;
    private final String typeIDLName;

    ParameterAnalysis(String javaName, Class cls) throws RMIIIOPViolationException {
        super(javaName);
        this.cls = cls;
        this.typeIDLName = Util.getTypeIDLName(cls);
        logger.debug((Object)("ParameterAnalysis(): cls=[" + cls.getName() + "] typeIDLName=[" + this.typeIDLName + "]."));
    }

    public ParameterMode getMode() {
        return ParameterMode.PARAM_IN;
    }

    public Class getCls() {
        return this.cls;
    }

    public String getTypeIDLName() {
        logger.debug((Object)("ParameterAnalysis.getTypeIDLName(): cls=[" + this.cls.getName() + "] typeIDLName=[" + this.typeIDLName + "]."));
        return this.typeIDLName;
    }
}

