/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.mgmt.ManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementChannelFactory;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.sasl.JBossSaslProvider;
import org.xnio.IoUtils;

public abstract class ManagementClientChannelStrategy {
    public abstract ManagementChannel getChannel() throws IOException;

    public abstract void requestDone();

    public static synchronized ManagementClientChannelStrategy create(ManagementChannel channel) {
        return new Existing(channel);
    }

    public static ManagementClientChannelStrategy create(String hostName, int port, Endpoint endpoint, ManagementOperationHandler handler, CallbackHandler cbHandler, Map<String, String> saslOptions) throws URISyntaxException, IOException {
        return new Establishing(hostName, port, endpoint, handler, cbHandler, saslOptions);
    }

    private static class Establishing
    extends ManagementClientChannelStrategy {
        private static final Provider saslProvider = new JBossSaslProvider();
        private final Endpoint endpoint;
        private final String hostName;
        private final int port;
        private final ManagementOperationHandler handler;
        private volatile ProtocolChannelClient<ManagementChannel> client;
        private volatile ManagementChannel channel;
        private final CallbackHandler callbackHandler;
        private final Map<String, String> saslOptions;

        public Establishing(String hostName, int port, Endpoint endpoint, ManagementOperationHandler handler, CallbackHandler callbackHandler, Map<String, String> saslOptions) {
            this.hostName = hostName;
            this.port = port;
            this.endpoint = endpoint;
            this.handler = handler;
            this.callbackHandler = callbackHandler;
            this.saslOptions = saslOptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ManagementChannel getChannel() throws IOException {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (Security.getProvider(saslProvider.getName()) == null) {
                        Security.insertProviderAt(saslProvider, 1);
                    }
                    return null;
                }
            });
            ProtocolChannelClient.Configuration<ManagementChannel> configuration = new ProtocolChannelClient.Configuration<ManagementChannel>();
            try {
                configuration.setEndpoint(this.endpoint);
                configuration.setUri(new URI("remote://" + this.hostName + ":" + this.port));
                configuration.setChannelFactory(new ManagementChannelFactory());
                this.client = ProtocolChannelClient.create(configuration);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            boolean ok = false;
            try {
                this.client.connect(this.callbackHandler, this.saslOptions);
                this.channel = this.client.openChannel("management");
                this.channel.setOperationHandler(this.handler);
                this.channel.startReceiving();
                ok = true;
            }
            finally {
                if (!ok) {
                    IoUtils.safeClose((Closeable)((Object)this.channel));
                    IoUtils.safeClose(this.client);
                }
            }
            return this.channel;
        }

        @Override
        public void requestDone() {
            IoUtils.safeClose(this.client);
        }
    }

    private static class Existing
    extends ManagementClientChannelStrategy {
        private final ManagementChannel channel;

        Existing(ManagementChannel channel) {
            this.channel = channel;
        }

        @Override
        public ManagementChannel getChannel() throws IOException {
            return this.channel;
        }

        @Override
        public void requestDone() {
        }
    }
}

