/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.jsfsession;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicateClientIDException
extends RuntimeException {
    public DuplicateClientIDException(String clientIDSuffix, List<String> clientIDs) {
        super(DuplicateClientIDException.makeMessage(clientIDSuffix, clientIDs));
    }

    public DuplicateClientIDException(List elements, String clientIDSuffix) {
        this(clientIDSuffix, DuplicateClientIDException.convertToStringList(elements));
    }

    private static List<String> convertToStringList(List<Object> elements) {
        ArrayList<String> ids = new ArrayList<String>(elements.size());
        for (Element element : elements) {
            ids.add(element.getAttribute("id"));
        }
        return ids;
    }

    private static String makeMessage(String clientIDSuffix, List<String> clientIDs) {
        String message = "'" + clientIDSuffix + "' matches more than one JSF component ID.  Use a more specific ID suffix.  Suffix matches: ";
        Iterator<String> i = clientIDs.iterator();
        while (i.hasNext()) {
            message = message + i.next();
            if (!i.hasNext()) continue;
            message = message + ", ";
        }
        return message;
    }
}

