/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding.source;

import java.util.Collection;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDataWriter
implements DataWriter<Node> {
    private static final Logger LOG = LogUtils.getL7dLogger(NodeDataWriter.class);

    public void write(Object obj, MessagePartInfo part, Node output) {
        this.write(obj, output);
    }

    public void write(Object obj, Node n) {
        try {
            Source s = (Source)obj;
            if (s instanceof DOMSource && ((DOMSource)s).getNode() == null) {
                return;
            }
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter((Element)n);
            StaxUtils.copy((Source)s, (XMLStreamWriter)writer);
        }
        catch (XMLStreamException e) {
            throw new Fault("COULD_NOT_WRITE_XML_STREAM_CAUSED_BY", LOG, (Throwable)e, new Object[]{e.getClass().getCanonicalName(), e.getMessage()});
        }
    }

    public void setSchema(Schema s) {
    }

    public void setAttachments(Collection<Attachment> attachments) {
    }

    public void setProperty(String key, Object value) {
    }
}

