/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.File;
import java.util.List;
import org.jboss.as.cli.CommandLineCompleter;

public abstract class FilenameTabCompleter
implements CommandLineCompleter {
    protected abstract boolean startsWithRoot(String var1);

    protected int getCandidates(String buffer, List<String> candidates) {
        String translated = this.translatePath(buffer);
        File f = new File(translated);
        File dir = translated.endsWith(File.separator) ? f : f.getParentFile();
        File[] entries = dir == null ? new File[]{} : dir.listFiles();
        return this.matchFiles(buffer, translated, entries, candidates);
    }

    public String translatePath(String path) {
        String translated = path.startsWith("~" + File.separator) ? System.getProperty("user.home") + path.substring(1) : (path.startsWith("~") ? new File(System.getProperty("user.home")).getParentFile().getAbsolutePath() : (!this.startsWithRoot(path) ? new File("").getAbsolutePath() + File.separator + path : path));
        return translated;
    }

    private static String unescapeName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch != '\\') continue;
            StringBuilder builder = new StringBuilder();
            builder.append(name, 0, i);
            boolean escaped = true;
            for (int j = i + 1; j < name.length(); ++j) {
                ch = name.charAt(j);
                if (escaped) {
                    builder.append(ch);
                    escaped = false;
                    continue;
                }
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                builder.append(ch);
            }
            return builder.toString();
        }
        return name;
    }

    protected int matchFiles(String buffer, String translated, File[] entries, List<String> candidates) {
        int i;
        if (entries == null) {
            return -1;
        }
        int matches = 0;
        for (i = 0; i < entries.length; ++i) {
            if (!entries[i].getAbsolutePath().startsWith(translated)) continue;
            ++matches;
        }
        for (i = 0; i < entries.length; ++i) {
            if (!entries[i].getAbsolutePath().startsWith(translated)) continue;
            String name = matches == 1 && entries[i].isDirectory() ? entries[i].getName() + File.separatorChar : entries[i].getName();
            candidates.add(name);
        }
        int index = buffer.lastIndexOf(File.separatorChar);
        return index + 1;
    }

    public static void main(String[] args) throws Exception {
        String name = "../../../../my\\ dir/";
        System.out.println(FilenameTabCompleter.unescapeName(name));
    }
}

