/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ModelValue;

final class TypeModelValue
extends ModelValue {
    public static final String TYPE_KEY = "TYPE_MODEL_VALUE";
    private final ModelType value;
    private static final TypeModelValue BOOLEAN = new TypeModelValue(ModelType.BOOLEAN);
    private static final TypeModelValue BYTES = new TypeModelValue(ModelType.BYTES);
    private static final TypeModelValue DECIMAL = new TypeModelValue(ModelType.BIG_DECIMAL);
    private static final TypeModelValue DOUBLE = new TypeModelValue(ModelType.DOUBLE);
    private static final TypeModelValue INT = new TypeModelValue(ModelType.INT);
    private static final TypeModelValue LONG = new TypeModelValue(ModelType.LONG);
    private static final TypeModelValue LIST = new TypeModelValue(ModelType.LIST);
    private static final TypeModelValue OBJECT = new TypeModelValue(ModelType.OBJECT);
    private static final TypeModelValue STRING = new TypeModelValue(ModelType.STRING);
    private static final TypeModelValue TYPE = new TypeModelValue(ModelType.TYPE);
    private static final TypeModelValue UNDEFINED = new TypeModelValue(ModelType.UNDEFINED);

    private TypeModelValue(ModelType value) {
        super(ModelType.TYPE);
        this.value = value;
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        out.writeByte(this.value.getTypeChar());
    }

    static TypeModelValue of(ModelType type) {
        switch (type) {
            case LONG: {
                return LONG;
            }
            case INT: {
                return INT;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case STRING: {
                return STRING;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case BIG_DECIMAL: {
                return DECIMAL;
            }
            case BYTES: {
                return BYTES;
            }
            case LIST: {
                return LIST;
            }
            case TYPE: {
                return TYPE;
            }
            case OBJECT: {
                return OBJECT;
            }
        }
        return UNDEFINED;
    }

    @Override
    boolean asBoolean() {
        return this.value != ModelType.UNDEFINED;
    }

    @Override
    boolean asBoolean(boolean defVal) {
        return this.value != ModelType.UNDEFINED;
    }

    @Override
    String asString() {
        return this.value.toString();
    }

    @Override
    ModelType asType() {
        return this.value;
    }

    @Override
    void formatAsJSON(PrintWriter writer, int indent, boolean multiLine) {
        writer.append('{');
        if (multiLine) {
            TypeModelValue.indent(writer.append('\n'), indent + 1);
        } else {
            writer.append(' ');
        }
        writer.append(TypeModelValue.jsonEscape(TYPE_KEY));
        writer.append(" : ");
        writer.append(TypeModelValue.jsonEscape(this.asString()));
        if (multiLine) {
            TypeModelValue.indent(writer.append('\n'), indent);
        } else {
            writer.append(' ');
        }
        writer.append('}');
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof TypeModelValue && this.equals((TypeModelValue)other);
    }

    public boolean equals(TypeModelValue other) {
        return this == other || other != null && other.value == this.value;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

