/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.server.recovery;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.api.core.client.ServerLocator;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.server.recovery.XARecoveryConfig;

public class HornetQXAResourceWrapper
implements XAResource,
SessionFailureListener {
    private static final Logger log = Logger.getLogger(HornetQXAResourceWrapper.class);
    private static final Object lock = new Object();
    private ServerLocator serverLocator;
    private ClientSessionFactory csf;
    private XAResource delegate;
    private XARecoveryConfig[] xaRecoveryConfigs;
    private TransportConfiguration currentConnection;

    public HornetQXAResourceWrapper(XARecoveryConfig ... xaRecoveryConfigs) {
        this.xaRecoveryConfigs = xaRecoveryConfigs;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        log.debug((Object)("Recover " + this.currentConnection));
        try {
            return xaResource.recover(flag);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        XAResource xaResource = this.getDelegate(true);
        log.debug((Object)("Commit " + this.currentConnection + " xid " + " onePhase=" + onePhase));
        try {
            xaResource.commit(xid, onePhase);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate(true);
        log.debug((Object)("Rollback " + this.currentConnection + " xid "));
        try {
            xaResource.rollback(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        log.debug((Object)("Forget " + this.currentConnection + " xid "));
        try {
            xaResource.forget(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (xaRes instanceof HornetQXAResourceWrapper) {
            xaRes = ((HornetQXAResourceWrapper)xaRes).getDelegate(false);
        }
        XAResource xaResource = this.getDelegate(false);
        try {
            return xaResource.isSameRM(xaRes);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate(true);
        log.debug((Object)("prepare " + this.currentConnection + " xid "));
        try {
            return xaResource.prepare(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        log.debug((Object)("start " + this.currentConnection + " xid "));
        try {
            xaResource.start(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        log.debug((Object)("end " + this.currentConnection + " xid "));
        try {
            xaResource.end(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        XAResource xaResource = this.getDelegate(false);
        log.debug((Object)("getTransactionTimeout " + this.currentConnection + " xid "));
        try {
            return xaResource.getTransactionTimeout();
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        log.debug((Object)("setTransactionTimeout " + this.currentConnection + " xid "));
        try {
            return xaResource.setTransactionTimeout(seconds);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void connectionFailed(HornetQException me, boolean failedOver) {
        log.warn((Object)("Notified of connection failure in xa recovery connectionFactory for provider " + this.currentConnection + " will attempt reconnect on next pass"), (Throwable)me);
        this.close();
    }

    public void beforeReconnect(HornetQException me) {
    }

    public XAResource getDelegate(boolean retry) throws XAException {
        XAResource result = null;
        Exception error = null;
        try {
            result = this.connect();
        }
        catch (Exception e) {
            error = e;
        }
        if (result == null) {
            if (retry) {
                XAException xae = new XAException("Connection unavailable for xa recovery");
                xae.errorCode = 4;
                if (error != null) {
                    xae.initCause(error);
                }
                log.debug((Object)"Cannot get connectionFactory XAResource", (Throwable)xae);
                throw xae;
            }
            XAException xae = new XAException("Error trying to connect to any providers for xa recovery");
            xae.errorCode = -3;
            if (error != null) {
                xae.initCause(error);
            }
            log.debug((Object)"Cannot get connectionFactory XAResource", (Throwable)xae);
            throw xae;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XAResource connect() throws Exception {
        Object object = lock;
        synchronized (object) {
            if (this.delegate != null) {
                return this.delegate;
            }
        }
        for (XARecoveryConfig xaRecoveryConfig : this.xaRecoveryConfigs) {
            ClientSession cs = null;
            try {
                this.serverLocator = HornetQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{xaRecoveryConfig.getTransportConfiguration()});
                this.serverLocator.disableFinalizeCheck();
                this.csf = this.serverLocator.createSessionFactory();
                cs = xaRecoveryConfig.getUsername() == null ? this.csf.createSession(true, false, false) : this.csf.createSession(xaRecoveryConfig.getUsername(), xaRecoveryConfig.getPassword(), true, false, false, false, 1);
            }
            catch (HornetQException e) {
                continue;
            }
            cs.addFailureListener((SessionFailureListener)this);
            Object object2 = lock;
            synchronized (object2) {
                this.delegate = cs;
                this.currentConnection = xaRecoveryConfig.getTransportConfiguration();
            }
            return this.delegate;
        }
        this.currentConnection = null;
        throw new HornetQException(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            ServerLocator oldServerLocator = null;
            ClientSessionFactory oldCSF = null;
            Object object = lock;
            synchronized (object) {
                oldCSF = this.csf;
                this.csf = null;
                this.delegate = null;
                oldServerLocator = this.serverLocator;
                this.serverLocator = null;
            }
            if (oldCSF != null) {
                oldCSF.close();
                oldServerLocator.close();
            }
        }
        catch (Exception ignored) {
            log.trace((Object)"Ignored error during close", (Throwable)ignored);
        }
    }

    protected XAException check(XAException e) throws XAException {
        if (e.errorCode == 4) {
            this.close();
        }
        throw e;
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

