/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.ejb.packaging.NamedInputStream;
import org.hibernate.ejb.packaging.Scanner;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.JpaMessages;
import org.jboss.as.jpa.hibernate4.HibernatePatternFilter;
import org.jboss.as.jpa.hibernate4.HibernateVirtualFileNamedInputStream;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class HibernateAnnotationScanner
implements Scanner {
    private static final ThreadLocal<PersistenceUnitMetadata> persistenceUnitMetadataTLS = new ThreadLocal();

    public static void setThreadLocalPersistenceUnitMetadata(PersistenceUnitMetadata pu) {
        persistenceUnitMetadataTLS.set(pu);
    }

    public static void clearThreadLocalPersistenceUnitMetadata() {
        persistenceUnitMetadataTLS.remove();
    }

    public Set<Package> getPackagesInJar(URL jartoScan, Set<Class<? extends Annotation>> annotationsToLookFor) {
        JpaLogger.JPA_LOGGER.tracef("getPackagesInJar url=%s annotations=%s", (Object)jartoScan.getPath(), annotationsToLookFor);
        Set<Object> resultClasses = new HashSet();
        if (annotationsToLookFor.size() > 0) {
            resultClasses = this.getClassesInJar(jartoScan, annotationsToLookFor);
        } else {
            PersistenceUnitMetadata pu = persistenceUnitMetadataTLS.get();
            if (pu == null) {
                throw JpaMessages.MESSAGES.missingPersistenceUnitMetadata();
            }
            if (jartoScan == null) {
                throw JpaMessages.MESSAGES.nullVar("jarToScan");
            }
            Index index = this.getJarFileIndex(jartoScan, pu);
            if (index == null) {
                JpaLogger.JPA_LOGGER.tracef("No classes to scan for annotations in jar '%s' (jars with classes '%s')", (Object)jartoScan, pu.getAnnotationIndex().keySet());
                return new HashSet<Package>();
            }
            Collection collection = index.getKnownClasses();
            for (ClassInfo classInfo : collection) {
                String className = classInfo.name().toString();
                try {
                    resultClasses.add(pu.getClassLoader().loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    throw JpaMessages.MESSAGES.cannotLoadEntityClass((Throwable)e, className);
                }
            }
        }
        HashMap<String, Package> uniquePackages = new HashMap<String, Package>();
        for (Class clazz : resultClasses) {
            Package classPackage = clazz.getPackage();
            if (classPackage == null) continue;
            JpaLogger.JPA_LOGGER.tracef("getPackagesInJar found package %s", (Object)classPackage);
            uniquePackages.put(classPackage.getName(), classPackage);
        }
        return new HashSet<Package>(uniquePackages.values());
    }

    private Index getJarFileIndex(URL jartoScan, PersistenceUnitMetadata pu) {
        return (Index)pu.getAnnotationIndex().get(jartoScan);
    }

    public Set<Class<?>> getClassesInJar(URL jartoScan, Set<Class<? extends Annotation>> annotationsToLookFor) {
        JpaLogger.JPA_LOGGER.tracef("getClassesInJar url=%s annotations=%s", (Object)jartoScan.getPath(), annotationsToLookFor);
        PersistenceUnitMetadata pu = persistenceUnitMetadataTLS.get();
        if (pu == null) {
            throw JpaMessages.MESSAGES.missingPersistenceUnitMetadata();
        }
        if (jartoScan == null) {
            throw JpaMessages.MESSAGES.nullVar("jarToScan");
        }
        Index index = this.getJarFileIndex(jartoScan, pu);
        if (index == null) {
            JpaLogger.JPA_LOGGER.tracef("No classes to scan for annotations in jar '%s' (jars with classes '%s')", (Object)jartoScan, pu.getAnnotationIndex().keySet());
            return new HashSet();
        }
        if (annotationsToLookFor == null) {
            throw JpaMessages.MESSAGES.nullVar("annotationsToLookFor");
        }
        if (annotationsToLookFor.size() == 0) {
            throw JpaMessages.MESSAGES.emptyParameter("annotationsToLookFor");
        }
        HashSet result = new HashSet();
        for (Class<? extends Annotation> annClass : annotationsToLookFor) {
            DotName annotation = DotName.createSimple((String)annClass.getName());
            List classesWithAnnotation = index.getAnnotations(annotation);
            for (AnnotationInstance annotationInstance : classesWithAnnotation) {
                if (!(annotationInstance.target() instanceof ClassInfo)) continue;
                String className = annotationInstance.target().toString();
                try {
                    JpaLogger.JPA_LOGGER.tracef("getClassesInJar found class %s with annotation %s", (Object)className, (Object)annClass.getName());
                    result.add(pu.getClassLoader().loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    throw JpaMessages.MESSAGES.cannotLoadEntityClass((Throwable)e, className);
                }
            }
        }
        return result;
    }

    public Set<NamedInputStream> getFilesInJar(URL jartoScan, Set<String> filePatterns) {
        if (jartoScan == null) {
            throw JpaMessages.MESSAGES.nullVar("jarToScan");
        }
        if (filePatterns == null) {
            throw JpaMessages.MESSAGES.nullVar("filePatterns");
        }
        HashSet<NamedInputStream> result = new HashSet<NamedInputStream>();
        HashMap<String, Set<NamedInputStream>> map = new HashMap<String, Set<NamedInputStream>>();
        this.findFiles(jartoScan, filePatterns, map, result);
        return result;
    }

    private void findFiles(URL jartoScan, Set<String> filePatterns, Map<String, Set<NamedInputStream>> map, Set<NamedInputStream> result) {
        if (filePatterns.isEmpty()) {
            for (Set<NamedInputStream> nims : map.values()) {
                result.addAll(nims);
            }
        } else {
            VirtualFile root = null;
            for (String pattern : filePatterns) {
                Set<NamedInputStream> niss = map.get(pattern);
                if (niss == null) {
                    if (root == null) {
                        root = this.getFile(jartoScan);
                    }
                    try {
                        List children = root.getChildrenRecursively((VirtualFileFilter)new HibernatePatternFilter(pattern));
                        niss = this.toNIS(children);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (niss == null) continue;
                result.addAll(niss);
            }
        }
    }

    private Set<NamedInputStream> toNIS(Iterable<VirtualFile> files) {
        HashSet<NamedInputStream> result = new HashSet<NamedInputStream>();
        for (VirtualFile file : files) {
            HibernateVirtualFileNamedInputStream nis = new HibernateVirtualFileNamedInputStream(file);
            result.add(nis);
        }
        return result;
    }

    public Set<NamedInputStream> getFilesInClasspath(Set<String> filePatterns) {
        throw JpaMessages.MESSAGES.notYetImplemented();
    }

    public String getUnqualifiedJarName(URL jarUrl) {
        VirtualFile file = this.getFile(jarUrl);
        return file.getName();
    }

    private VirtualFile getFile(URL url) {
        try {
            return VFS.getChild((URI)url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

