/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.picketlink.identity.federation.api.util.DeflateUtil;
import org.picketlink.identity.federation.core.util.Base64;
import org.picketlink.identity.federation.core.util.StringUtil;

public class RedirectBindingUtil {
    public static String urlEncode(String str) throws IOException {
        return URLEncoder.encode(str, "UTF-8");
    }

    public static String urlDecode(String str) throws IOException {
        return URLDecoder.decode(str, "UTF-8");
    }

    public static String base64URLEncode(byte[] stringToEncode) throws IOException {
        String base64Request = Base64.encodeBytes(stringToEncode, 8);
        return RedirectBindingUtil.urlEncode(base64Request);
    }

    public static byte[] urlBase64Decode(String encodedString) throws IOException {
        String decodedString = RedirectBindingUtil.urlDecode(encodedString);
        return Base64.decode(decodedString);
    }

    public static String deflateBase64URLEncode(String stringToEncode) throws IOException {
        return RedirectBindingUtil.deflateBase64URLEncode(stringToEncode.getBytes("UTF-8"));
    }

    public static String deflateBase64URLEncode(byte[] stringToEncode) throws IOException {
        byte[] deflatedMsg = DeflateUtil.encode(stringToEncode);
        return RedirectBindingUtil.base64URLEncode(deflatedMsg);
    }

    public static String deflateBase64Encode(byte[] stringToEncode) throws IOException {
        byte[] deflatedMsg = DeflateUtil.encode(stringToEncode);
        return Base64.encodeBytes(deflatedMsg);
    }

    public static InputStream urlBase64DeflateDecode(String encodedString) throws IOException {
        byte[] deflatedString = RedirectBindingUtil.urlBase64Decode(encodedString);
        return DeflateUtil.decode(deflatedString);
    }

    public static InputStream base64DeflateDecode(String encodedString) {
        byte[] base64decodedMsg = Base64.decode(encodedString);
        return DeflateUtil.decode(base64decodedMsg);
    }

    public static String getDestinationQueryString(String urlEncodedRequest, String urlEncodedRelayState, boolean sendRequest) {
        StringBuilder sb = new StringBuilder();
        if (sendRequest) {
            sb.append("SAMLRequest=").append(urlEncodedRequest);
        } else {
            sb.append("SAMLResponse=").append(urlEncodedRequest);
        }
        if (StringUtil.isNotNull(urlEncodedRelayState)) {
            sb.append("&RelayState=").append(urlEncodedRelayState);
        }
        return sb.toString();
    }

    public static String getDestinationURL(RedirectBindingUtilDestHolder holder) throws UnsupportedEncodingException, IOException {
        String destination = holder.destination;
        StringBuilder destinationURL = new StringBuilder(destination);
        if (destination.contains("?")) {
            destinationURL.append("&");
        } else {
            destinationURL.append("?");
        }
        destinationURL.append(holder.destinationQueryString);
        return destinationURL.toString();
    }

    public static class RedirectBindingUtilDestHolder {
        private String destination;
        private String destinationQueryString;

        public RedirectBindingUtilDestHolder setDestinationQueryString(String dest) {
            this.destinationQueryString = dest;
            return this;
        }

        public RedirectBindingUtilDestHolder setDestination(String dest) {
            this.destination = dest;
            return this;
        }
    }
}

