/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Map;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.spi.AbstractModule;
import org.jboss.osgi.resolver.spi.AbstractPackageRequirement;

public class AbstractDynamicPackageRequirement
extends AbstractPackageRequirement {
    public AbstractDynamicPackageRequirement(AbstractModule module, String name, Map<String, String> dirs, Map<String, Object> atts) {
        super(module, name, dirs, atts);
        this.setOptional(true);
        this.setDynamic(true);
    }

    @Override
    public boolean matchPackageName(XPackageCapability cap) {
        String packageName = this.getName();
        if (packageName.equals("*")) {
            return true;
        }
        if (packageName.endsWith(".*")) {
            packageName = packageName.substring(0, packageName.length() - 2);
            return cap.getName().startsWith(packageName);
        }
        return packageName.equals(cap.getName());
    }

    @Override
    public String toString() {
        return "DynamicImport-Package[" + this.getName() + ":" + this.getVersionRange() + "]";
    }
}

