/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Map;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.deployment.WebAttachments;
import org.jboss.as.web.deployment.component.WebComponentDescription;
import org.jboss.as.web.deployment.component.WebComponentInstantiator;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.webtier.jsp.JspInitializationListener;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMappingMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.metadata.web.spec.FiltersMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.weld.servlet.ConversationPropagationFilter;
import org.jboss.weld.servlet.WeldListener;

public class WebIntegrationProcessor
implements DeploymentUnitProcessor {
    private final ListenerMetaData WBL = new ListenerMetaData();
    private final ListenerMetaData JIL;
    private final FilterMetaData CPF;
    private final FilterMappingMetaData CPFM;
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.weld");
    private static final String WELD_LISTENER = WeldListener.class.getName();
    private static final String JSP_LISTENER = JspInitializationListener.class.getName();
    private static final String CONVERSATION_FILTER = ConversationPropagationFilter.class.getName();
    private static final String WELD_SERVLET_LISTENER = "org.jboss.weld.environment.servlet.Listener";

    public WebIntegrationProcessor() {
        this.WBL.setListenerClass(WELD_LISTENER);
        this.JIL = new ListenerMetaData();
        this.JIL.setListenerClass(JSP_LISTENER);
        this.CPF = new FilterMetaData();
        this.CPF.setFilterName("Weld Conversation Propagation Filter");
        this.CPF.setFilterClass(CONVERSATION_FILTER);
        this.CPF.setAsyncSupported(true);
        this.CPFM = new FilterMappingMetaData();
        this.CPFM.setFilterName("Weld Conversation Propagation Filter");
        this.CPFM.setUrlPatterns(Arrays.asList("/*"));
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription module = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        if (!WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit)) {
            return;
        }
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            log.info((Object)"Not installing Weld web tier integration as no war metadata found");
            return;
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            log.info((Object)"Not installing Weld web tier integration as no merged web metadata found");
            return;
        }
        ArrayList<ListenerMetaData> listeners = webMetaData.getListeners();
        if (listeners == null) {
            listeners = new ArrayList<ListenerMetaData>();
            webMetaData.setListeners(listeners);
        } else {
            ListIterator iterator = listeners.listIterator();
            while (iterator.hasNext()) {
                ListenerMetaData listener = (ListenerMetaData)iterator.next();
                if (!listener.getListenerClass().trim().equals(WELD_SERVLET_LISTENER)) continue;
                log.debugf("Removing weld servlet listener %s from web config, as it is not needed in EE6 environments", (Object)WELD_SERVLET_LISTENER);
                iterator.remove();
                break;
            }
        }
        listeners.add(0, this.WBL);
        listeners.add(1, this.JIL);
        WebComponentDescription componentDescription = new WebComponentDescription(JSP_LISTENER, JSP_LISTENER, module, deploymentUnit.getServiceName(), applicationClasses);
        module.addComponent((ComponentDescription)componentDescription);
        Map instantiators = (Map)deploymentUnit.getAttachment(WebAttachments.WEB_COMPONENT_INSTANTIATORS);
        instantiators.put(JSP_LISTENER, new WebComponentInstantiator(deploymentUnit, (ComponentDescription)componentDescription));
        FiltersMetaData filters = webMetaData.getFilters();
        if (filters == null) {
            filters = new FiltersMetaData();
            webMetaData.setFilters(filters);
        }
        filters.add((MappableMetaData)this.CPF);
        ArrayList<FilterMappingMetaData> filterMappings = webMetaData.getFilterMappings();
        if (filterMappings == null) {
            filterMappings = new ArrayList<FilterMappingMetaData>();
            webMetaData.setFilterMappings(filterMappings);
        }
        filterMappings.add(this.CPFM);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

