/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jacorb.naming.jndi;

import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.as.jacorb.naming.jndi.CNCtx;
import org.jboss.as.jacorb.naming.jndi.UrlUtil;

public final class IiopUrl {
    private static final int DEFAULT_IIOPNAME_PORT = 9999;
    private static final int DEFAULT_IIOP_PORT = 900;
    private static final String DEFAULT_HOST = "localhost";
    private Vector addresses;
    private String stringName;

    public Vector getAddresses() {
        return this.addresses;
    }

    public String getStringName() {
        return this.stringName;
    }

    public Name getCosName() throws NamingException {
        return CNCtx.parser.parse(this.stringName);
    }

    public IiopUrl(String url) throws MalformedURLException {
        int addrStart;
        boolean oldFormat;
        if (url.startsWith("iiopname://")) {
            oldFormat = false;
            addrStart = 11;
        } else if (url.startsWith("iiop://")) {
            oldFormat = true;
            addrStart = 7;
        } else {
            throw new MalformedURLException("Invalid iiop/iiopname URL: " + url);
        }
        int addrEnd = url.indexOf(47, addrStart);
        if (addrEnd < 0) {
            addrEnd = url.length();
            this.stringName = "";
        } else {
            this.stringName = UrlUtil.decode(url.substring(addrEnd + 1));
        }
        this.addresses = new Vector(3);
        if (oldFormat) {
            this.addresses.addElement(new Address(url.substring(addrStart, addrEnd), oldFormat));
        } else {
            StringTokenizer tokens = new StringTokenizer(url.substring(addrStart, addrEnd), ",");
            while (tokens.hasMoreTokens()) {
                this.addresses.addElement(new Address(tokens.nextToken(), oldFormat));
            }
            if (this.addresses.size() == 0) {
                this.addresses.addElement(new Address("", oldFormat));
            }
        }
    }

    public static class Address {
        public int port = -1;
        public int major;
        public int minor;
        public String host;

        public Address(String hostPortVers, boolean oldFormat) throws MalformedURLException {
            int start;
            int at;
            if (oldFormat || (at = hostPortVers.indexOf(64)) < 0) {
                this.major = 1;
                this.minor = 0;
                start = 0;
            } else {
                int dot = hostPortVers.indexOf(46);
                if (dot < 0) {
                    throw new MalformedURLException("invalid version: " + hostPortVers);
                }
                try {
                    this.major = Integer.parseInt(hostPortVers.substring(0, dot));
                    this.minor = Integer.parseInt(hostPortVers.substring(dot + 1, at));
                }
                catch (NumberFormatException e) {
                    throw new MalformedURLException("Nonnumeric version: " + hostPortVers);
                }
                start = at + 1;
            }
            int slash = hostPortVers.indexOf(47, start);
            if (slash < 0) {
                slash = hostPortVers.length();
            }
            if (hostPortVers.startsWith("[", start)) {
                int brac = hostPortVers.indexOf(93, start + 1);
                if (brac < 0 || brac > slash) {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + hostPortVers);
                }
                this.host = hostPortVers.substring(start, brac + 1);
                start = brac + 1;
            } else {
                int hostEnd;
                int colon = hostPortVers.indexOf(58, start);
                int n = hostEnd = colon < 0 || colon > slash ? slash : colon;
                if (start < hostEnd) {
                    this.host = hostPortVers.substring(start, hostEnd);
                }
                start = hostEnd;
            }
            if (start + 1 < slash) {
                if (hostPortVers.startsWith(":", start)) {
                    this.port = Integer.parseInt(hostPortVers.substring(++start, slash));
                } else {
                    throw new IllegalArgumentException("IiopURL: name is an Invalid URL: " + hostPortVers);
                }
            }
            start = slash;
            if ("".equals(this.host) || this.host == null) {
                this.host = IiopUrl.DEFAULT_HOST;
            }
            if (this.port == -1) {
                this.port = oldFormat ? 900 : 9999;
            }
        }
    }
}

