/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.obr;

import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.internal.obr.AbstractBundleRepositoryRenderHelper;
import org.apache.felix.webconsole.internal.obr.OsgiDeployer;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.obr.Capability;
import org.osgi.service.obr.Repository;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;

public class OsgiBundleRepositoryRenderHelper
extends AbstractBundleRepositoryRenderHelper {
    static /* synthetic */ Class class$org$osgi$service$obr$RepositoryAdmin;

    public OsgiBundleRepositoryRenderHelper(AbstractWebConsolePlugin logger, BundleContext bundleContext) {
        super(logger, bundleContext, (class$org$osgi$service$obr$RepositoryAdmin == null ? (class$org$osgi$service$obr$RepositoryAdmin = OsgiBundleRepositoryRenderHelper.class$("org.osgi.service.obr.RepositoryAdmin")) : class$org$osgi$service$obr$RepositoryAdmin).getName());
    }

    String getData(String filter, boolean details, Bundle[] bundles) {
        RepositoryAdmin admin = (RepositoryAdmin)this.getRepositoryAdmin();
        if (admin != null) {
            JSONObject json = new JSONObject();
            try {
                json.put("status", admin != null);
                json.put("details", details);
                Repository[] repositories = admin.listRepositories();
                for (int i = 0; repositories != null && i < repositories.length; ++i) {
                    json.append("repositories", (Object)new JSONObject().put("lastModified", repositories[i].getLastModified()).put("name", (Object)repositories[i].getName()).put("url", (Object)repositories[i].getURL()));
                }
                Resource[] resources = admin.discoverResources(filter);
                for (int i = 0; resources != null && i < resources.length; ++i) {
                    json.append("resources", (Object)this.toJSON(resources[i], bundles, details));
                }
            }
            catch (JSONException e) {
                this.logger.log("Failed to serialize repository to JSON object.", e);
            }
            catch (Exception e) {
                this.logger.log("Failed to parse filter '" + filter + "'", e);
                try {
                    String reason = "filter=" + filter;
                    if (e.getMessage() != null) {
                        reason = e.getMessage() + "(" + reason + ")";
                    }
                    json.put("error", (Object)reason);
                }
                catch (JSONException je) {
                    // empty catch block
                }
            }
            return json.toString();
        }
        return "{}";
    }

    private String parseRequirement(String req) {
        int p = req.indexOf(58);
        String filter = p > 0 ? req.substring(p + 1) : req;
        if (!filter.startsWith("(")) {
            filter = "(" + filter + ")";
        }
        return filter;
    }

    void doAction(String action, String urlParam) throws IOException, ServletException {
        URL uri;
        RepositoryAdmin admin = (RepositoryAdmin)this.getRepositoryAdmin();
        Repository[] repos = admin.listRepositories();
        Repository repo = this.getRepository(repos, urlParam);
        URL uRL = uri = repo != null ? repo.getURL() : new URL(urlParam);
        if ("delete".equals(action)) {
            if (!admin.removeRepository(uri)) {
                throw new ServletException("Failed to remove repository with URL " + uri);
            }
        } else if ("add".equals(action) || "refresh".equals(action)) {
            try {
                admin.addRepository(uri);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException("Failed to " + action + " repository " + uri + ": " + e.toString());
            }
        }
    }

    final void doDeploy(String[] bundles, boolean start, boolean optional) {
        if (bundles == null || bundles.length == 0) {
            this.logger.log("No resources to deploy");
            return;
        }
        RepositoryAdmin repoAdmin = (RepositoryAdmin)this.getRepositoryAdmin();
        Resolver resolver = repoAdmin.resolver();
        for (int i = 0; i < bundles.length; ++i) {
            String filter;
            Resource[] resources;
            String bundle = bundles[i];
            if (bundle == null || bundle.equals("-") || (resources = repoAdmin.discoverResources(filter = "(id=" + bundle + ")")) == null || resources.length <= 0) continue;
            resolver.add(resources[0]);
        }
        OsgiDeployer.deploy(resolver, this.logger, start);
    }

    private final Repository getRepository(Repository[] repos, String repositoryUrl) {
        if (repositoryUrl == null || repositoryUrl.length() == 0) {
            return null;
        }
        for (int i = 0; i < repos.length; ++i) {
            if (!repositoryUrl.equals(repos[i].getURL().toString())) continue;
            return repos[i];
        }
        return null;
    }

    private final JSONObject toJSON(Resource resource, Bundle[] bundles, boolean details) throws JSONException {
        String symbolicName = resource.getSymbolicName();
        String version = resource.getVersion().toString();
        boolean installed = false;
        for (int i = 0; symbolicName != null && !installed && bundles != null && i < bundles.length; ++i) {
            String ver = (String)bundles[i].getHeaders("").get("Bundle-Version");
            installed = symbolicName.equals(bundles[i].getSymbolicName()) && version.equals(ver);
        }
        JSONObject json = new JSONObject(resource.getProperties()).put("id", (Object)resource.getId()).put("presentationname", (Object)resource.getPresentationName()).put("symbolicname", (Object)symbolicName).put("url", (Object)resource.getURL()).put("version", (Object)version).put("categories", (Object)resource.getCategories()).put("installed", installed);
        if (details) {
            Capability[] caps = resource.getCapabilities();
            for (int i = 0; caps != null && i < caps.length; ++i) {
                json.append("capabilities", (Object)new JSONObject().put("name", (Object)caps[i].getName()).put("properties", (Object)new JSONObject(caps[i].getProperties())));
            }
            Requirement[] reqs = resource.getRequirements();
            for (int i = 0; reqs != null && i < reqs.length; ++i) {
                json.append("requirements", (Object)new JSONObject().put("name", (Object)reqs[i].getName()).put("filter", (Object)reqs[i].getFilter()).put("optional", reqs[i].isOptional()));
            }
            RepositoryAdmin admin = (RepositoryAdmin)this.getRepositoryAdmin();
            Resolver resolver = admin.resolver();
            resolver.add(resource);
            resolver.resolve();
            Resource[] required = resolver.getRequiredResources();
            for (int i = 0; required != null && i < required.length; ++i) {
                json.append("required", (Object)this.toJSON(required[i], bundles, false));
            }
            Resource[] optional = resolver.getOptionalResources();
            for (int i = 0; optional != null && i < optional.length; ++i) {
                json.append("optional", (Object)this.toJSON(optional[i], bundles, false));
            }
            Requirement[] unsatisfied = resolver.getUnsatisfiedRequirements();
            for (int i = 0; unsatisfied != null && i < unsatisfied.length; ++i) {
                json.append("unsatisfied", (Object)new JSONObject().put("name", (Object)unsatisfied[i].getName()).put("filter", (Object)unsatisfied[i].getFilter()).put("optional", unsatisfied[i].isOptional()));
            }
        }
        return json;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

