/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.puparser;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.config.PersistenceUnitMetadataImpl;
import org.jboss.as.jpa.puparser.Attribute;
import org.jboss.as.jpa.puparser.Element;
import org.jboss.as.jpa.puparser.Version;
import org.jboss.as.jpa.spi.PersistenceUnitMetadata;
import org.jboss.metadata.parser.util.MetaDataElementParser;

public class PersistenceUnitXmlParser
extends MetaDataElementParser {
    private static final boolean traceEnabled = JpaLogger.JPA_LOGGER.isTraceEnabled();

    public static PersistenceUnitMetadataHolder parse(XMLStreamReader reader) throws XMLStreamException {
        Attribute attribute;
        String attributeNamespace;
        reader.require(7, null, null);
        Version version = null;
        while (reader.hasNext() && reader.next() != 1) {
            String dtdLocation;
            if (reader.getEventType() != 11 || (dtdLocation = PersistenceUnitXmlParser.readDTDLocation((XMLStreamReader)reader)) == null) continue;
            version = Version.forLocation(dtdLocation);
        }
        String schemaLocation = PersistenceUnitXmlParser.readSchemaLocation((XMLStreamReader)reader);
        if (schemaLocation != null) {
            version = Version.forLocation(schemaLocation);
        }
        if (version == null || Version.UNKNOWN.equals((Object)version)) {
            String versionString = null;
            int count = reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                attributeNamespace = reader.getAttributeNamespace(i);
                if (attributeNamespace != null && !attributeNamespace.isEmpty() || (attribute = Attribute.forName(reader.getAttributeLocalName(i))) != Attribute.VERSION) continue;
                versionString = reader.getAttributeValue(i);
            }
            version = "1.0".equals(versionString) ? Version.JPA_1_0 : ("1".equals(versionString) ? Version.JPA_1_0 : ("2.0".equals(versionString) ? Version.JPA_2_0 : ("2".equals(versionString) ? Version.JPA_2_0 : Version.JPA_2_0)));
        }
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) continue;
            attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSION: {
                    continue block8;
                }
                default: {
                    throw PersistenceUnitXmlParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ArrayList<PersistenceUnitMetadata> PUs = new ArrayList<PersistenceUnitMetadata>();
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PERSISTENCEUNIT: {
                    PersistenceUnitMetadata pu = PersistenceUnitXmlParser.parsePU(reader, version);
                    PUs.add(pu);
                    JpaLogger.JPA_LOGGER.readingPersistenceXml(pu.getPersistenceUnitName());
                    continue block9;
                }
            }
            throw PersistenceUnitXmlParser.unexpectedElement((XMLStreamReader)reader);
        }
        PersistenceUnitMetadataHolder result = new PersistenceUnitMetadataHolder().setPersistenceUnits(PUs);
        if (JpaLogger.JPA_LOGGER.isTraceEnabled()) {
            JpaLogger.JPA_LOGGER.trace((Object)result.toString());
        }
        return result;
    }

    private static PersistenceUnitMetadata parsePU(XMLStreamReader reader, Version version) throws XMLStreamException {
        PersistenceUnitMetadataImpl pu = new PersistenceUnitMetadataImpl();
        ArrayList<String> classes = new ArrayList<String>(1);
        ArrayList<String> jarfiles = new ArrayList<String>(1);
        ArrayList<String> mappingFiles = new ArrayList<String>(1);
        Properties properties = new Properties();
        pu.setTransactionType(PersistenceUnitTransactionType.JTA);
        pu.setValidationMode(ValidationMode.AUTO);
        pu.setSharedCacheMode(SharedCacheMode.UNSPECIFIED);
        pu.setPersistenceProviderClassName("org.hibernate.ejb.HibernatePersistence");
        if (version.equals((Object)Version.JPA_1_0)) {
            pu.setPersistenceXMLSchemaVersion("1.0");
        } else {
            pu.setPersistenceXMLSchemaVersion("2.0");
        }
        int count = reader.getAttributeCount();
        block17: for (int i = 0; i < count; ++i) {
            String attributeNamespace;
            String value = reader.getAttributeValue(i);
            if (traceEnabled) {
                JpaLogger.JPA_LOGGER.tracef("parse persistence.xml: attribute value(%d) = %s", (Object)i, (Object)value);
            }
            if ((attributeNamespace = reader.getAttributeNamespace(i)) != null && !attributeNamespace.isEmpty()) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    pu.setPersistenceUnitName(value);
                    continue block17;
                }
                case TRANSACTIONTYPE: {
                    if (!value.equalsIgnoreCase("RESOURCE_LOCAL")) continue block17;
                    pu.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
                    continue block17;
                }
                default: {
                    throw PersistenceUnitXmlParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block18: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (traceEnabled) {
                JpaLogger.JPA_LOGGER.tracef("parse persistence.xml: element=%s", (Object)element.getLocalName());
            }
            switch (element) {
                case CLASS: {
                    classes.add(reader.getElementText());
                    continue block18;
                }
                case DESCRIPTION: {
                    String description = reader.getElementText();
                    continue block18;
                }
                case EXCLUDEUNLISTEDCLASSES: {
                    String text = reader.getElementText();
                    if (text == null || text.isEmpty()) {
                        pu.setExcludeUnlistedClasses(true);
                        continue block18;
                    }
                    pu.setExcludeUnlistedClasses(Boolean.valueOf(text));
                    continue block18;
                }
                case JARFILE: {
                    String file = reader.getElementText();
                    jarfiles.add(file);
                    continue block18;
                }
                case JTADATASOURCE: {
                    pu.setJtaDataSourceName(reader.getElementText());
                    continue block18;
                }
                case NONJTADATASOURCE: {
                    pu.setNonJtaDataSourceName(reader.getElementText());
                    continue block18;
                }
                case MAPPINGFILE: {
                    mappingFiles.add(reader.getElementText());
                    continue block18;
                }
                case PROPERTIES: {
                    PersistenceUnitXmlParser.parseProperties(reader, properties);
                    continue block18;
                }
                case PROVIDER: {
                    pu.setPersistenceProviderClassName(reader.getElementText());
                    continue block18;
                }
                case SHAREDCACHEMODE: {
                    String cm = reader.getElementText();
                    pu.setSharedCacheMode(SharedCacheMode.valueOf((String)cm));
                    continue block18;
                }
                case VALIDATIONMODE: {
                    String validationMode = reader.getElementText();
                    pu.setValidationMode(ValidationMode.valueOf((String)validationMode));
                    continue block18;
                }
            }
            throw PersistenceUnitXmlParser.unexpectedElement((XMLStreamReader)reader);
        }
        if (traceEnabled) {
            JpaLogger.JPA_LOGGER.trace((Object)"parse persistence.xml: reached ending persistence-unit tag");
        }
        pu.setManagedClassNames(classes);
        pu.setJarFiles(jarfiles);
        pu.setMappingFiles(mappingFiles);
        pu.setProperties(properties);
        return pu;
    }

    private static void parseProperties(XMLStreamReader reader, Properties properties) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    int count = reader.getAttributeCount();
                    String name = null;
                    String value = null;
                    block8: for (int i = 0; i < count; ++i) {
                        String attributeValue = reader.getAttributeValue(i);
                        String attributeNamespace = reader.getAttributeNamespace(i);
                        if (attributeNamespace != null && !attributeNamespace.isEmpty()) continue;
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                name = attributeValue;
                                continue block8;
                            }
                            case VALUE: {
                                value = attributeValue;
                                if (name != null && value != null) {
                                    properties.put(name, value);
                                }
                                value = null;
                                name = null;
                                continue block8;
                            }
                            default: {
                                throw PersistenceUnitXmlParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (!reader.hasNext() || reader.nextTag() == 2) continue block7;
                    throw PersistenceUnitXmlParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
            throw PersistenceUnitXmlParser.unexpectedElement((XMLStreamReader)reader);
        }
    }

    public static void main(String[] args) {
        try {
            String filename = args.length < 1 ? "persistence.xml" : args[0];
            System.out.println("will parse " + filename);
            XMLInputFactory xmlif = XMLInputFactory.newInstance();
            XMLStreamReader reader = xmlif.createXMLStreamReader(filename, new FileInputStream(filename));
            PersistenceUnitMetadataHolder h = PersistenceUnitXmlParser.parse(reader);
            System.out.println("result = " + h.getPersistenceUnits());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

