/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleIdentity;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResolverCallback;
import org.jboss.osgi.resolver.XResolverException;
import org.jboss.osgi.resolver.XWire;
import org.jboss.osgi.resolver.spi.AbstractModule;
import org.jboss.osgi.resolver.spi.AbstractWire;

public abstract class AbstractResolver
implements XResolver {
    private static Logger log = Logger.getLogger(AbstractResolver.class);
    private XResolverCallback callback;
    private Map<XModuleIdentity, XModule> moduleMap = new LinkedHashMap<XModuleIdentity, XModule>();
    private Map<XRequirement, XCapability> reqcapMap = new ConcurrentHashMap<XRequirement, XCapability>();
    private Map<XCapability, Set<XRequirement>> capreqMap = new ConcurrentHashMap<XCapability, Set<XRequirement>>();

    public AbstractResolver() {
        this.callback = new XResolverCallback(){

            public void markResolved(XModule module) {
            }
        };
    }

    public void setCallbackHandler(XResolverCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Null callback");
        }
        this.callback = callback;
    }

    protected XResolverCallback getCallbackHandler() {
        return this.callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModule(XModule module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        if (log.isTraceEnabled()) {
            StringBuffer buffer = ((AbstractModule)module).toLongString(new StringBuffer());
            log.trace((Object)buffer);
        }
        Map<XModuleIdentity, XModule> map = this.moduleMap;
        synchronized (map) {
            XModuleIdentity moduleId = module.getModuleId();
            if (this.moduleMap.get(moduleId) != null) {
                throw new IllegalStateException("Module already added: " + module);
            }
            this.moduleMap.put(moduleId, module);
            ((AbstractModule)module).setResolver(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModule(XModule module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        Object object = this.moduleMap;
        synchronized (object) {
            XModule result = this.moduleMap.remove(module.getModuleId());
            if (result != null) {
                ((AbstractModule)result).setResolver(null);
            }
        }
        object = this;
        synchronized (object) {
            for (XRequirement req : module.getRequirements()) {
                Set<XRequirement> reqset;
                XCapability cap = this.reqcapMap.get(req);
                if (cap == null || (reqset = this.capreqMap.get(cap)) == null) continue;
                reqset.remove(req);
            }
            for (XCapability cap : module.getCapabilities()) {
                this.capreqMap.remove(cap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<XModule> getModules() {
        Map<XModuleIdentity, XModule> map = this.moduleMap;
        synchronized (map) {
            LinkedHashSet<XModule> values = new LinkedHashSet<XModule>(this.moduleMap.values());
            return Collections.unmodifiableSet(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XModule getModuleById(XModuleIdentity moduleId) {
        Map<XModuleIdentity, XModule> map = this.moduleMap;
        synchronized (map) {
            return this.moduleMap.get(moduleId);
        }
    }

    public final void resolve(XModule module) throws XResolverException {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        if (this.getModuleById(module.getModuleId()) == null) {
            throw new IllegalStateException("Module not registered: " + module);
        }
        try {
            module.removeAttachment(XResolverException.class);
            this.resolveInternal(module);
        }
        catch (XResolverException rex) {
            module.addAttachment(XResolverException.class, (Object)rex);
            throw rex;
        }
    }

    protected abstract void resolveInternal(XModule var1);

    public boolean resolveAll(Set<XModule> unresolved) {
        if (unresolved == null) {
            unresolved = new LinkedHashSet<XModule>();
            for (XModule aux : this.getModules()) {
                if (aux.isResolved()) continue;
                unresolved.add(aux);
            }
        }
        boolean allResolved = true;
        for (XModule module : unresolved) {
            if (module == null) {
                throw new IllegalArgumentException("Null module");
            }
            if (this.getModuleById(module.getModuleId()) == null) {
                throw new IllegalStateException("Module not registered: " + module);
            }
            try {
                module.removeAttachment(XResolverException.class);
                this.resolveInternal(module);
            }
            catch (XResolverException ex) {
                module.addAttachment(XResolverException.class, (Object)ex);
                allResolved = false;
            }
        }
        return allResolved;
    }

    protected void setResolved(AbstractModule module) {
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        module.setResolved();
        try {
            this.callback.markResolved((XModule)module);
        }
        catch (RuntimeException ex) {
            System.err.println("Error in callback: " + this.callback.getClass().getName());
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XWire addWire(AbstractModule importer, XRequirement req, XModule exporter, XCapability cap) {
        AbstractWire wire = new AbstractWire(importer, req, exporter, cap);
        importer.addWire(wire);
        AbstractResolver abstractResolver = this;
        synchronized (abstractResolver) {
            this.reqcapMap.put(req, cap);
            Set<XRequirement> reqset = this.capreqMap.get(cap);
            if (reqset == null) {
                reqset = new LinkedHashSet<XRequirement>();
                this.capreqMap.put(cap, reqset);
            }
            reqset.add(req);
        }
        return wire;
    }

    Set<XRequirement> getWiredRequirements(XCapability cap) {
        if (!cap.getModule().isResolved()) {
            return null;
        }
        Set<XRequirement> reqset = this.capreqMap.get(cap);
        if (reqset == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(reqset);
    }

    XCapability getWiredCapability(XRequirement req) {
        return this.reqcapMap.get(req);
    }
}

