/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.management.MBeanServer;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.ProtocolConfiguration;
import org.jboss.as.clustering.jgroups.ProtocolDefaults;
import org.jboss.as.clustering.jgroups.ProtocolStackConfiguration;
import org.jboss.as.clustering.jgroups.TransportConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsDescriptions;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolDefaultsService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.JBossExecutors;

public class ProtocolStackAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static ModelNode createOperation(ModelNode address, ModelNode existing) {
        ModelNode operation = Util.getEmptyOperation((String)"add", (ModelNode)address);
        ProtocolStackAdd.populate(existing, operation);
        return operation;
    }

    private static void populate(ModelNode source, ModelNode target) {
        target.get("transport").set(source.require("transport"));
        if (source.hasDefined("protocol")) {
            ModelNode protocols = target.get("protocol");
            for (ModelNode protocol : source.get("protocol").asList()) {
                protocols.add(protocol);
            }
        }
    }

    public ModelNode getModelDescription(Locale locale) {
        return JGroupsDescriptions.getProtocolStackAddDescription(locale);
    }

    protected void populateModel(ModelNode operation, ModelNode model) {
        ProtocolStackAdd.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ModelNode transport = operation.get("transport");
        Transport transportConfig = new Transport(transport.require("type").asString());
        ProtocolStack stackConfig = new ProtocolStack(name, transportConfig);
        ServiceBuilder builder = context.getServiceTarget().addService(ChannelFactoryService.getServiceName(name), (Service)new ChannelFactoryService(stackConfig)).addDependency(ProtocolDefaultsService.SERVICE_NAME, ProtocolDefaults.class, stackConfig.getDefaultsInjector()).addDependency(ServiceBuilder.DependencyType.OPTIONAL, ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, stackConfig.getMBeanServerInjector()).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, stackConfig.getEnvironmentInjector());
        if (transport.hasDefined("shared")) {
            transportConfig.setShared(transport.get("shared").asBoolean());
        }
        this.build((ServiceBuilder<ChannelFactory>)builder, transport, transportConfig);
        this.addSocketBindingDependency((ServiceBuilder<ChannelFactory>)builder, transport, "diagnostics-socket-binding", transportConfig.getDiagnosticsSocketBindingInjector());
        this.addExecutorDependency((ServiceBuilder<ChannelFactory>)builder, transport, "default-executor", transportConfig.getDefaultExecutorInjector());
        this.addExecutorDependency((ServiceBuilder<ChannelFactory>)builder, transport, "oob-executor", transportConfig.getOOBExecutorInjector());
        if (transport.hasDefined("timer-executor")) {
            builder.addDependency(ThreadsServices.executorName((String)transport.get("timer-executor").asString()), ScheduledExecutorService.class, transportConfig.getTimerExecutorInjector());
        }
        if (transport.hasDefined("thread-factory")) {
            builder.addDependency(ThreadsServices.threadFactoryName((String)transport.get("thread-factory").asString()), ThreadFactory.class, transportConfig.getThreadFactoryInjector());
        }
        for (ModelNode protocol : operation.get("protocol").asList()) {
            Protocol protocolConfig = new Protocol(protocol.require("type").asString());
            this.build((ServiceBuilder<ChannelFactory>)builder, protocol, protocolConfig);
            stackConfig.getProtocols().add(protocolConfig);
        }
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        newControllers.add(builder.install());
    }

    private void build(ServiceBuilder<ChannelFactory> builder, ModelNode protocol, Protocol protocolConfig) {
        this.addSocketBindingDependency(builder, protocol, "socket-binding", protocolConfig.getSocketBindingInjector());
        Map<String, String> properties = protocolConfig.getProperties();
        if (protocol.hasDefined("property")) {
            for (Property property : protocol.get("property").asPropertyList()) {
                properties.put(property.getName(), property.getValue().asString());
            }
        }
    }

    private void addSocketBindingDependency(ServiceBuilder<ChannelFactory> builder, ModelNode model, String key, Injector<SocketBinding> injector) {
        if (model.hasDefined(key)) {
            builder.addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{model.get(key).asString()}), SocketBinding.class, injector);
        }
    }

    private void addExecutorDependency(ServiceBuilder<ChannelFactory> builder, ModelNode model, String key, Injector<Executor> injector) {
        if (model.hasDefined(key)) {
            builder.addDependency(ThreadsServices.executorName((String)model.get(key).asString()), Executor.class, injector);
        }
    }

    protected boolean requiresRuntimeVerification() {
        return false;
    }

    static class Protocol
    implements ProtocolConfiguration {
        private final String name;
        private final InjectedValue<SocketBinding> socketBinding = new InjectedValue();
        private final Map<String, String> properties = new HashMap<String, String>();
        private final Class<?> protocolClass;

        Protocol(String name) {
            this.name = name;
            try {
                this.protocolClass = this.getClass().getClassLoader().loadClass("org.jgroups.protocols." + name);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean hasProperty(String property) {
            return Protocol.getField(this.protocolClass, property) != null;
        }

        private static Field getField(Class<?> targetClass, String property) {
            try {
                return targetClass.getDeclaredField(property);
            }
            catch (NoSuchFieldException e) {
                Class<?> superClass = targetClass.getSuperclass();
                return superClass != null && org.jgroups.stack.Protocol.class.isAssignableFrom(superClass) ? Protocol.getField(superClass, property) : null;
            }
        }

        @Override
        public Map<String, String> getProperties() {
            return this.properties;
        }

        Injector<SocketBinding> getSocketBindingInjector() {
            return this.socketBinding;
        }

        @Override
        public SocketBinding getSocketBinding() {
            return (SocketBinding)this.socketBinding.getOptionalValue();
        }
    }

    static class Transport
    extends Protocol
    implements TransportConfiguration {
        private final InjectedValue<SocketBinding> diagnosticsSocketBinding = new InjectedValue();
        private final InjectedValue<Executor> defaultExecutor = new InjectedValue();
        private final InjectedValue<Executor> oobExecutor = new InjectedValue();
        private final InjectedValue<ScheduledExecutorService> timerExecutor = new InjectedValue();
        private final InjectedValue<ThreadFactory> threadFactory = new InjectedValue();
        private boolean shared = true;

        Transport(String name) {
            super(name);
        }

        Injector<SocketBinding> getDiagnosticsSocketBindingInjector() {
            return this.diagnosticsSocketBinding;
        }

        Injector<Executor> getDefaultExecutorInjector() {
            return this.defaultExecutor;
        }

        Injector<Executor> getOOBExecutorInjector() {
            return this.oobExecutor;
        }

        Injector<ScheduledExecutorService> getTimerExecutorInjector() {
            return this.timerExecutor;
        }

        Injector<ThreadFactory> getThreadFactoryInjector() {
            return this.threadFactory;
        }

        void setShared(boolean shared) {
            this.shared = shared;
        }

        @Override
        public boolean isShared() {
            return this.shared;
        }

        @Override
        public SocketBinding getDiagnosticsSocketBinding() {
            return (SocketBinding)this.diagnosticsSocketBinding.getOptionalValue();
        }

        @Override
        public ExecutorService getDefaultExecutor() {
            Executor executor = (Executor)this.defaultExecutor.getOptionalValue();
            return executor != null ? JBossExecutors.protectedExecutorService((Executor)executor) : null;
        }

        @Override
        public ExecutorService getOOBExecutor() {
            Executor executor = (Executor)this.oobExecutor.getOptionalValue();
            return executor != null ? JBossExecutors.protectedExecutorService((Executor)executor) : null;
        }

        @Override
        public ScheduledExecutorService getTimerExecutor() {
            return (ScheduledExecutorService)this.timerExecutor.getOptionalValue();
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return (ThreadFactory)this.threadFactory.getOptionalValue();
        }
    }

    static class ProtocolStack
    implements ProtocolStackConfiguration {
        private final InjectedValue<ProtocolDefaults> defaults = new InjectedValue();
        private final InjectedValue<MBeanServer> mbeanServer = new InjectedValue();
        private final InjectedValue<ServerEnvironment> environment = new InjectedValue();
        private final String name;
        private final TransportConfiguration transport;
        private final List<ProtocolConfiguration> protocols = new LinkedList<ProtocolConfiguration>();

        ProtocolStack(String name, TransportConfiguration transport) {
            this.name = name;
            this.transport = transport;
        }

        Injector<ProtocolDefaults> getDefaultsInjector() {
            return this.defaults;
        }

        Injector<MBeanServer> getMBeanServerInjector() {
            return this.mbeanServer;
        }

        Injector<ServerEnvironment> getEnvironmentInjector() {
            return this.environment;
        }

        @Override
        public TransportConfiguration getTransport() {
            return this.transport;
        }

        @Override
        public List<ProtocolConfiguration> getProtocols() {
            return this.protocols;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ProtocolDefaults getDefaults() {
            return (ProtocolDefaults)this.defaults.getValue();
        }

        @Override
        public MBeanServer getMBeanServer() {
            return (MBeanServer)this.mbeanServer.getOptionalValue();
        }

        @Override
        public ServerEnvironment getEnvironment() {
            return (ServerEnvironment)this.environment.getValue();
        }
    }
}

