/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jdr;

import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.jdr.JdrLogger;
import org.jboss.as.jdr.JdrMessages;
import org.jboss.as.jdr.JdrReport;
import org.jboss.as.jdr.ModelControllerClientProxy;
import org.jboss.dmr.ModelNode;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class SosInterpreter {
    private String jbossHomeDir = null;
    private String reportLocationDir = System.getProperty("user.dir");
    private ModelControllerClient controllerClient = null;

    public SosInterpreter() {
        this.jbossHomeDir = System.getProperty("jboss.home.dir");
        if (this.jbossHomeDir == null) {
            this.jbossHomeDir = System.getenv("JBOSS_HOME");
        }
        JdrLogger.ROOT_LOGGER.debug("JBoss Home directory: " + this.jbossHomeDir);
    }

    public JdrReport collect() throws OperationFailedException {
        JdrLogger.ROOT_LOGGER.startingCollection();
        Date startTime = new Date();
        String homeDir = this.getJbossHomeDir();
        if (homeDir == null) {
            JdrLogger.ROOT_LOGGER.jbossHomeNotSet();
            throw new OperationFailedException(JdrMessages.MESSAGES.jbossHomeNotSet(), new ModelNode().set(JdrMessages.MESSAGES.jbossHomeNotSet()));
        }
        PythonInterpreter interpreter = new PythonInterpreter();
        interpreter.exec("import sys");
        interpreter.exec("import shlex");
        String pyLocation = this.getPythonScriptLocation();
        JdrLogger.ROOT_LOGGER.debug("Location of JDR scripts: " + pyLocation);
        String locationDir = this.getReportLocationDir();
        JdrLogger.ROOT_LOGGER.debug("locationDir = " + locationDir);
        JdrLogger.ROOT_LOGGER.debug("homeDir = " + SosInterpreter.cleanPath(homeDir));
        PyObject report = null;
        try {
            interpreter.exec("sys.path.append(\"" + pyLocation + "\")");
            if (this.controllerClient != null) {
                interpreter.exec("import sos");
                interpreter.set("controller_client_proxy", (Object)new ModelControllerClientProxy(this.controllerClient));
                interpreter.exec("sos.controllerClient = controller_client_proxy");
            }
            interpreter.exec("from sos.sosreport import main");
            interpreter.exec("args = shlex.split('-k eap6.home=\"" + homeDir + "\" --tmp-dir=\"" + locationDir + "\" -o eap6 --batch --report --compression-type=zip --silent')");
            interpreter.exec("reportLocation = main(args)");
            report = interpreter.get("reportLocation");
            interpreter.cleanup();
        }
        catch (Throwable t) {
            interpreter.cleanup();
            JdrLogger.ROOT_LOGGER.pythonExceptionEncountered(t);
        }
        Date endTime = new Date();
        JdrLogger.ROOT_LOGGER.endingCollection();
        JdrReport result = new JdrReport();
        result.setStartTime(startTime);
        result.setEndTime(endTime);
        result.setLocation(report.asString());
        return result;
    }

    public void setReportLocationDir(String dir) {
        this.reportLocationDir = dir;
    }

    public String getReportLocationDir() {
        return SosInterpreter.cleanPath(this.reportLocationDir);
    }

    public void setControllerClient(ModelControllerClient controllerClient) {
        this.controllerClient = controllerClient;
    }

    public String getJbossHomeDir() {
        if (this.jbossHomeDir == null) {
            this.jbossHomeDir = System.getenv("JBOSS_HOME");
        }
        return SosInterpreter.cleanPath(this.jbossHomeDir);
    }

    public void setJbossHomeDir(String jbossHomeDir) throws IllegalArgumentException {
        if (jbossHomeDir == null) {
            throw JdrMessages.MESSAGES.varNull("jbossHomeDir");
        }
        this.jbossHomeDir = jbossHomeDir;
    }

    public static String getPath(String path) {
        return path.split(":", 2)[1].split("!")[0];
    }

    public static String cleanPath(String path) {
        try {
            path = URLDecoder.decode(path, "utf-8");
        }
        catch (Exception e) {
            JdrLogger.ROOT_LOGGER.debug(e);
        }
        return path.replace("\\", "\\\\");
    }

    private String getPythonScriptLocation() {
        URL pyURL = this.getClass().getClassLoader().getResource("sos");
        String decodedPath = SosInterpreter.cleanPath(pyURL.getPath());
        return SosInterpreter.getPath(decodedPath);
    }
}

