/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding.jbossxb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.apache.xerces.xs.XSModel;
import org.jboss.logging.Logger;
import org.jboss.util.xml.JBossEntityResolver;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.Constants;
import org.jboss.ws.common.utils.JBossWSEntityResolver;
import org.jboss.ws.extensions.xop.jaxrpc.JBossXBContentAdapter;
import org.jboss.ws.metadata.jaxrpcmapping.ExceptionMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.xb.binding.metadata.ClassMetaData;
import org.jboss.xb.binding.metadata.PackageMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultSchemaResolver;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SimpleTypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
import org.jboss.xb.binding.sunday.unmarshalling.impl.runtime.RtElementHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

public class SchemaBindingBuilder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SchemaBindingBuilder.class);
    private static final Logger log = Logger.getLogger(SchemaBindingBuilder.class);

    public SchemaBinding buildSchemaBinding(XSModel model, JavaWsdlMapping wsdlMapping) {
        JBossWSEntityResolver resolver = new JBossWSEntityResolver();
        SchemaBinding schemaBinding = XsdBinder.bind((XSModel)model, (SchemaBindingResolver)new DefaultSchemaResolver((JBossEntityResolver)resolver));
        schemaBinding.setIgnoreLowLine(false);
        schemaBinding.setIgnoreUnresolvedFieldOrClass(false);
        schemaBinding.setUnmarshalListsToArrays(true);
        schemaBinding.setSimpleContentProperty("_value");
        schemaBinding.setUseNoArgCtorIfFound(true);
        schemaBinding.setReplacePropertyRefs(false);
        if (wsdlMapping != null) {
            this.bindSchemaToJava(schemaBinding, wsdlMapping);
        }
        JBossXBContentAdapter.register(schemaBinding);
        return schemaBinding;
    }

    private void bindSchemaToJava(SchemaBinding schemaBinding, JavaWsdlMapping wsdlMapping) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("bindSchemaToJava: " + schemaBinding));
        }
        for (PackageMapping packageMapping : wsdlMapping.getPackageMappings()) {
            this.processPackageMapping(schemaBinding, packageMapping);
        }
        for (Serializable serializable : wsdlMapping.getExceptionMappings()) {
            this.processExceptionMapping(schemaBinding, (ExceptionMapping)serializable);
        }
        for (Serializable serializable : wsdlMapping.getJavaXmlTypeMappings()) {
            this.processJavaXmlTypeMapping(schemaBinding, (JavaXmlTypeMapping)serializable);
        }
    }

    private void processPackageMapping(SchemaBinding schemaBinding, PackageMapping packageMapping) {
        PackageMetaData packageMetaData = schemaBinding.getPackageMetaData();
        if (packageMetaData == null) {
            packageMetaData = new PackageMetaData();
            schemaBinding.setPackageMetaData(packageMetaData);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Bound namespace " + packageMapping.getNamespaceURI() + " to package " + packageMapping.getPackageType()));
        }
        packageMetaData.setName(packageMapping.getPackageType());
    }

    private void processJavaXmlTypeMapping(SchemaBinding schemaBinding, JavaXmlTypeMapping typeMapping) {
        String javaType = typeMapping.getJavaType();
        if (javaType.endsWith("[]")) {
            this.processArrayType(schemaBinding, typeMapping);
        } else {
            this.processNonArrayType(schemaBinding, typeMapping);
        }
    }

    private void processExceptionMapping(SchemaBinding schemaBinding, ExceptionMapping exceptionMapping) {
        QName xmlType = exceptionMapping.getWsdlMessage();
        String javaType = exceptionMapping.getExceptionType();
        log.trace((Object)("processExceptionMapping: [xmlType=" + xmlType + ",javaType=" + javaType + "]"));
        if (schemaBinding.getType(xmlType) == null) {
            TypeBinding typeBinding = new TypeBinding(xmlType);
            ClassMetaData cmd = new ClassMetaData();
            cmd.setUseNoArgCtor(Boolean.FALSE);
            cmd.setImpl(javaType);
            typeBinding.setClassMetaData(cmd);
            typeBinding.setSimple(false);
            schemaBinding.addType(typeBinding);
        }
    }

    private void processArrayType(SchemaBinding schemaBinding, JavaXmlTypeMapping typeMapping) {
        QName xmlType = this.getXmlType(typeMapping);
        log.trace((Object)("Ignore array type: " + xmlType));
    }

    private void processNonArrayType(SchemaBinding schemaBinding, JavaXmlTypeMapping typeMapping) {
        QName xmlType = this.getXmlType(typeMapping);
        String javaType = typeMapping.getJavaType();
        log.trace((Object)("processNonArrayType: [xmlType=" + xmlType + ",javaType=" + javaType + "]"));
        TypeBinding typeBinding = this.getTypeBinding(schemaBinding, typeMapping);
        if (typeBinding != null) {
            VariableMapping[] variableMappings;
            boolean isSimpleTypeBinding = typeBinding instanceof SimpleTypeBinding;
            if (!isSimpleTypeBinding) {
                ClassMetaData classMetaData = typeBinding.getClassMetaData();
                if (classMetaData == null) {
                    classMetaData = new ClassMetaData();
                    typeBinding.setClassMetaData(classMetaData);
                }
                classMetaData.setImpl(javaType);
                JavaWsdlMapping wsdlMapping = typeMapping.getJavaWsdlMapping();
                for (ExceptionMapping aux : wsdlMapping.getExceptionMappings()) {
                    if (!javaType.equals(aux.getExceptionType())) continue;
                    classMetaData.setUseNoArgCtor(Boolean.valueOf(false));
                    break;
                }
                if (log.isTraceEnabled()) {
                    QName typeQName = typeBinding.getQName();
                    log.trace((Object)("Bound: [xmlType=" + typeQName + ",javaType=" + javaType + "]"));
                }
            }
            for (VariableMapping varMapping : variableMappings = typeMapping.getVariableMappings()) {
                if (varMapping.getXmlElementName() != null) {
                    this.processXmlElementName(typeBinding, varMapping);
                    continue;
                }
                if (varMapping.getXmlAttributeName() != null) {
                    this.processXmlAttributeName(typeBinding, varMapping);
                    continue;
                }
                if (!varMapping.getXmlWildcard()) continue;
                this.processWildcard(typeBinding, varMapping);
            }
        } else {
            log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_TYPE_BINDING", (Object[])new Object[]{xmlType}));
        }
    }

    private void processXmlAttributeName(TypeBinding typeBinding, VariableMapping varMapping) {
        String xmlAttrName = varMapping.getXmlAttributeName();
        log.trace((Object)("processXmlAttributeName: " + xmlAttrName));
        QName xmlName = new QName(xmlAttrName);
        AttributeBinding attrBinding = typeBinding.getAttribute(xmlName);
        if (attrBinding == null) {
            for (AttributeBinding auxBinding : typeBinding.getAttributes()) {
                if (!auxBinding.getQName().getLocalPart().equals(xmlAttrName)) continue;
                if (attrBinding != null) {
                    log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"AMBIGUOUS_BINDING", (Object[])new Object[]{xmlAttrName}));
                }
                attrBinding = auxBinding;
            }
        }
        if (attrBinding == null) {
            String nsURI = typeBinding.getQName().getNamespaceURI();
            if ("mustUnderstand".equals(xmlAttrName) || "actor".equals(xmlAttrName) || "role".equals(xmlAttrName)) {
                nsURI = "http://schemas.xmlsoap.org/soap/envelope/";
            }
            QName auxName = new QName(nsURI, xmlAttrName);
            attrBinding = typeBinding.getAttribute(auxName);
        }
        if (attrBinding == null) {
            QName typeQName = typeBinding.getQName();
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ATTRIBUTE_NOT_IN_SCHEMA", (Object[])new Object[]{xmlName, typeQName}));
        }
        String javaVariableName = varMapping.getJavaVariableName();
        PropertyMetaData prop = new PropertyMetaData();
        prop.setName(javaVariableName);
        attrBinding.setPropertyMetaData(prop);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Bound attribute " + xmlName + " to property " + prop.getName()));
        }
    }

    private void processXmlElementName(TypeBinding typeBinding, VariableMapping varMapping) {
        TermBinding term;
        ParticleBinding particle;
        QName xmlName = new QName(varMapping.getXmlElementName());
        log.trace((Object)("processXmlElementName: " + xmlName));
        ElementBinding element = typeBinding.getElement(xmlName);
        QName typeQName = typeBinding.getQName();
        if (element == null && typeQName != null) {
            String nsURI = typeQName.getNamespaceURI();
            QName auxName = new QName(nsURI, varMapping.getXmlElementName());
            element = typeBinding.getElement(auxName);
        }
        if (element == null && (particle = typeBinding.getParticle()) != null && (term = particle.getTerm()) instanceof ModelGroupBinding) {
            Iterator iterator = ((ModelGroupBinding)term).getParticles().iterator();
            element = this.findLocalPathElement(iterator, new String[]{varMapping.getXmlElementName()}, 0);
        }
        if (element == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ELEMENT_NOT_IN_SCHEMA", (Object[])new Object[]{xmlName, typeQName}));
        }
        String javaVariableName = varMapping.getJavaVariableName();
        if (javaVariableName != null) {
            PropertyMetaData prop = new PropertyMetaData();
            prop.setName(javaVariableName);
            element.setPropertyMetaData(prop);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Bound element " + xmlName + " to property " + prop.getName()));
            }
        }
    }

    private void processWildcard(TypeBinding typeBinding, VariableMapping varMapping) {
        log.trace((Object)("processWildcard: " + typeBinding.getQName()));
        PropertyMetaData prop = null;
        String javaVariableName = varMapping.getJavaVariableName();
        if (javaVariableName != null) {
            prop = new PropertyMetaData();
            prop.setName(javaVariableName);
        }
        if (prop == null) {
            prop = new PropertyMetaData();
            prop.setName("_any");
        }
        WildcardBinding wildcard = typeBinding.getWildcard();
        wildcard.setUnresolvedElementHandler((ParticleHandler)new SoapElementHandler());
        wildcard.setUnresolvedCharactersHandler((CharactersHandler)new SoapCharactersHandler());
        wildcard.setPropertyMetaData(prop);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Bound wildcard of " + typeBinding.getQName() + " to property " + prop.getName()));
        }
    }

    private TypeBinding getTypeBinding(SchemaBinding schemaBinding, JavaXmlTypeMapping typeMapping) {
        String qnameScope = typeMapping.getQnameScope();
        QName anonymousTypeQName = typeMapping.getAnonymousTypeQName();
        if (anonymousTypeQName != null) {
            return this.getAnonymousTypeBinding(schemaBinding, anonymousTypeQName);
        }
        QName xmlType = typeMapping.getRootTypeQName();
        TypeBinding typeBinding = null;
        if ("complexType".equals(qnameScope) || "simpleType".equals(qnameScope)) {
            typeBinding = schemaBinding.getType(xmlType);
            if (typeBinding == null) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"TYPE_DEFINITION_NOT_FOUND_IN_SCHEMA", (Object[])new Object[]{xmlType}));
            }
        } else if ("element".equals(qnameScope)) {
            ElementBinding element = schemaBinding.getElement(xmlType);
            if (element != null) {
                typeBinding = element.getType();
            } else {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"GLOBAL_ELEMENT_NOT_FOUND_IN_SCHEMA", (Object[])new Object[]{xmlType}));
            }
        } else {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNEXPECTED_QNAME_SCOPE", (Object[])new Object[]{typeMapping.getJavaType(), qnameScope}));
        }
        return typeBinding;
    }

    public TypeBinding getAnonymousTypeBinding(SchemaBinding schemaBinding, QName typeQName) {
        String expression = typeQName.getLocalPart();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Searching for anonymous expression: " + expression));
        }
        ArrayList<String> list = new ArrayList<String>(10);
        int begin = -1;
        for (int i = 0; i < expression.length(); ++i) {
            if (expression.charAt(i) == '>') {
                if (begin == -1) continue;
                list.add(expression.substring(begin, i));
                begin = -1;
                continue;
            }
            if (begin == -1) {
                begin = i;
                continue;
            }
            if (i != expression.length() - 1) continue;
            list.add(expression.substring(begin));
        }
        ElementBinding element = this.findLocalPathElement(schemaBinding.getElements(), list.toArray(new String[0]));
        if (element == null) {
            element = this.findLocalPathElementInTypes(schemaBinding.getTypes(), list.toArray(new String[0]));
        }
        if (element == null) {
            return null;
        }
        return element.getType();
    }

    public void bindParameterToElement(SchemaBinding schemaBinding, QName xmlName, QName xmlType) {
        boolean isAnonymousType = xmlType.getLocalPart().startsWith(">");
        TypeBinding typeBinding = isAnonymousType ? this.getAnonymousTypeBinding(schemaBinding, xmlType) : schemaBinding.getType(xmlType);
        if (typeBinding != null) {
            if (!isAnonymousType) {
                ElementBinding eb = schemaBinding.addElement(xmlName, typeBinding);
                eb.setNillable(true);
            }
        } else if (!xmlType.equals(Constants.TYPE_LITERAL_ANYTYPE)) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ROOT_TYPE_NOT_FOUND_IN_SCHEMA", (Object[])new Object[]{xmlType}));
        }
    }

    private ElementBinding findLocalPathElement(Iterator elements, String[] path) {
        while (elements.hasNext()) {
            ElementBinding element = (ElementBinding)elements.next();
            if ((element = this.findLocalPathElement(element, path, 0)) == null) continue;
            return element;
        }
        return null;
    }

    private ElementBinding findLocalPathElementInTypes(Iterator types, String[] path) {
        while (types.hasNext()) {
            TermBinding term;
            ParticleBinding particle;
            TypeBinding type = (TypeBinding)types.next();
            if (!type.getQName().getLocalPart().equals(path[0]) || (particle = type.getParticle()) == null || !(term = particle.getTerm()).isModelGroup()) continue;
            return this.findLocalPathElement(((ModelGroupBinding)term).getParticles().iterator(), path, 1);
        }
        return null;
    }

    private ElementBinding findLocalPathElement(ElementBinding element, String[] path, int pos) {
        String name = path[pos];
        if (!name.equals(element.getQName().getLocalPart())) {
            return null;
        }
        if (path.length - 1 == pos) {
            return element;
        }
        ParticleBinding particle = element.getType().getParticle();
        if (particle == null) {
            return null;
        }
        TermBinding term = particle.getTerm();
        if (!term.isModelGroup()) {
            return null;
        }
        ModelGroupBinding group = (ModelGroupBinding)term;
        Iterator i = group.getParticles().iterator();
        return this.findLocalPathElement(i, path, pos + 1);
    }

    private ElementBinding findLocalPathElement(Iterator particles, String[] path, int pos) {
        while (particles.hasNext()) {
            Iterator i;
            ElementBinding element;
            TermBinding term = ((ParticleBinding)particles.next()).getTerm();
            if (term instanceof ElementBinding) {
                ElementBinding element2 = (ElementBinding)term;
                if ((element2 = this.findLocalPathElement(element2, path, pos)) == null) continue;
                return element2;
            }
            if (!(term instanceof ModelGroupBinding) || (element = this.findLocalPathElement(i = ((ModelGroupBinding)term).getParticles().iterator(), path, pos)) == null) continue;
            return element;
        }
        return null;
    }

    private QName getXmlType(JavaXmlTypeMapping typeMapping) {
        QName xmlType = typeMapping.getRootTypeQName();
        if (xmlType == null && typeMapping.getAnonymousTypeQName() != null) {
            xmlType = typeMapping.getAnonymousTypeQName();
        }
        return xmlType;
    }

    public static class SoapElementHandler
    extends RtElementHandler
    implements ParticleHandler {
        private SOAPFactory factory;

        public Object startParticle(Object parent, QName elementName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx) {
            SOAPFactory factory = this.getFactory();
            SOAPElement element = null;
            try {
                String prefix = elementName.getPrefix();
                String ns = elementName.getNamespaceURI();
                if (ns != null && ns.length() > 0) {
                    prefix = nsCtx.getPrefix(ns);
                }
                element = factory.createElement(elementName.getLocalPart(), prefix, ns);
            }
            catch (SOAPException e) {
                throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_CREATE_SOAPELEMENT", (Object[])new Object[0]), e);
            }
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    element.setAttribute(attrs.getLocalName(i), attrs.getValue(i));
                }
            }
            return element;
        }

        public Object endParticle(Object o, QName elementName, ParticleBinding particle) {
            return o;
        }

        public void setParent(Object parent, Object o, QName elementName, ParticleBinding particle, ParticleBinding parentParticle) {
            if (parent instanceof SOAPElement) {
                ((SOAPElement)parent).appendChild((Node)((Element)o));
            } else {
                super.setParent(parent, o, elementName, particle, parentParticle);
            }
        }

        private SOAPFactory getFactory() {
            if (this.factory == null) {
                try {
                    this.factory = SOAPFactory.newInstance();
                }
                catch (SOAPException e) {
                    throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_CREATE_SOAPELEMENT_FACTORY", (Object[])new Object[0]), e);
                }
            }
            return this.factory;
        }
    }

    public static class SoapCharactersHandler
    extends CharactersHandler {
        public Object unmarshalEmpty(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData) {
            return "";
        }

        public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
            return value;
        }

        public void setValue(QName qName, ElementBinding element, Object owner, Object value) {
            SOAPElement e = (SOAPElement)owner;
            Text textNode = e.getOwnerDocument().createTextNode((String)value);
            e.appendChild((Node)textNode);
        }
    }
}

