/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import com.sun.xml.bind.api.JAXBRIContext;
import com.sun.xml.bind.api.TypeReference;
import com.sun.xml.bind.v2.model.annotation.RuntimeAnnotationReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.binding.BindingCustomization;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.jaxws.JAXBContextFactory;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.EndpointAssociation;

public class CustomizableJAXBContextFactory
extends JAXBContextFactory {
    private static final ResourceBundle bundle = BundleUtils.getBundle(CustomizableJAXBContextFactory.class);
    protected Logger log = Logger.getLogger(CustomizableJAXBContextFactory.class);

    @Override
    public JAXBContext createContext(Class clazz) throws WSException {
        return this.createContext(new Class[]{clazz});
    }

    @Override
    public JAXBContext createContext(Class[] clazzes) throws WSException {
        try {
            BindingCustomization bcust = this.getCustomization();
            JAXBContext jaxbCtx = null == bcust ? JAXBContext.newInstance((Class[])clazzes) : this.createContext(clazzes, bcust);
            this.incrementContextCount();
            return jaxbCtx;
        }
        catch (JAXBException e) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_CREATE_JAXBCONTEXT", (Object[])new Object[0]), e);
        }
    }

    @Override
    public JAXBContext createContext(final Class[] clazzes, final BindingCustomization bcust) throws WSException {
        JAXBContext jaxbCtx = null;
        try {
            jaxbCtx = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                @Override
                public JAXBContext run() throws PrivilegedActionException {
                    try {
                        return JAXBContext.newInstance((Class[])clazzes, (Map)bcust);
                    }
                    catch (JAXBException e) {
                        throw new PrivilegedActionException((Exception)((Object)e));
                    }
                }
            });
            this.incrementContextCount();
        }
        catch (Exception e) {
            if (bcust != null && bcust.get((Object)"com.sun.xml.bind.defaultNamespaceRemap") != null) {
                String dns = (String)bcust.get((Object)"com.sun.xml.bind.defaultNamespaceRemap");
                bcust.remove((Object)"com.sun.xml.bind.defaultNamespaceRemap");
                bcust.put((Object)"com.sun.xml.internal.bind.defaultNamespaceRemap", (Object)dns);
                try {
                    jaxbCtx = AccessController.doPrivileged(new PrivilegedExceptionAction<JAXBContext>(){

                        @Override
                        public JAXBContext run() throws PrivilegedActionException {
                            try {
                                return JAXBContext.newInstance((Class[])clazzes, (Map)bcust);
                            }
                            catch (JAXBException e) {
                                throw new PrivilegedActionException((Exception)((Object)e));
                            }
                        }
                    });
                    this.incrementContextCount();
                }
                catch (Exception ex) {
                    throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_CREATE_JAXBCONTEXT", (Object[])new Object[0]), ex);
                }
            }
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_CREATE_JAXBCONTEXT", (Object[])new Object[0]), e);
        }
        return jaxbCtx;
    }

    @Override
    public JAXBRIContext createContext(Class[] classes, Collection<TypeReference> refs, String defaultNS, boolean c14n, BindingCustomization bcust) {
        try {
            RuntimeAnnotationReader anReader = null;
            if (bcust != null) {
                anReader = (RuntimeAnnotationReader)bcust.get((Object)JAXBRIContext.ANNOTATION_READER);
            }
            JAXBRIContext jaxbCtx = JAXBRIContext.newInstance((Class[])classes, refs, null, (String)defaultNS, (boolean)c14n, (RuntimeAnnotationReader)anReader);
            this.incrementContextCount();
            return jaxbCtx;
        }
        catch (JAXBException e) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"FAILED_TO_CREATE_JAXBCONTEXT", (Object[])new Object[0]), e);
        }
    }

    private BindingCustomization getCustomization() {
        Endpoint ep = EndpointAssociation.getEndpoint();
        return ep != null ? (BindingCustomization)ep.getAttachment(BindingCustomization.class) : null;
    }
}

