/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.handler;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.core.HTTPMessageImpl;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.soap.EnvelopeBuilderDOM;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.core.soap.XMLFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LogicalMessageImpl
implements LogicalMessage {
    private static final ResourceBundle bundle = BundleUtils.getBundle(LogicalMessageImpl.class);
    private static final Logger log = Logger.getLogger(LogicalMessageImpl.class);
    private Style style;
    private MessageAbstraction message;

    public LogicalMessageImpl(MessageAbstraction message, Style style) {
        this.style = style;
        this.message = message;
    }

    public Source getPayload() {
        Source source = null;
        if (this.message instanceof SOAPMessage) {
            SOAPMessage soapMessage = (SOAPMessage)this.message;
            SOAPBodyImpl soapBody = this.getSOAPBody(soapMessage);
            SOAPElement bodyElement = this.getBodyElement(soapBody);
            if (this.style == Style.RPC) {
                source = new DOMSource((Node)bodyElement);
            } else {
                SOAPContentElement contentElement = (SOAPContentElement)bodyElement;
                source = contentElement.getXMLFragment().getSource();
            }
        } else if (this.message instanceof HTTPMessageImpl) {
            HTTPMessageImpl httpMessage = (HTTPMessageImpl)this.message;
            source = httpMessage.getXmlFragment().getSource();
        }
        return source;
    }

    public void setPayload(Source source) {
        if (this.message instanceof SOAPMessage) {
            SOAPMessage soapMessage = (SOAPMessage)this.message;
            SOAPBodyImpl soapBody = this.getSOAPBody(soapMessage);
            SOAPElement bodyElement = this.getBodyElement(soapBody);
            try {
                if (this.style == Style.RPC) {
                    try {
                        soapBody.removeContents();
                        EnvelopeBuilderDOM envBuilder = new EnvelopeBuilderDOM();
                        envBuilder.setStyle(this.style);
                        Element domBodyElement = DOMUtils.sourceToElement((Source)source);
                        envBuilder.buildBodyElementRpc(soapBody, domBodyElement);
                    }
                    catch (IOException ex) {
                        WSException.rethrow(ex);
                    }
                }
                SOAPContentElement contentElement = (SOAPContentElement)bodyElement;
                contentElement.setXMLFragment(new XMLFragment(source));
            }
            catch (SOAPException ex) {
                throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_SET_XML_PAYLOAD", (Object[])new Object[0]), (Throwable)ex);
            }
        } else if (this.message instanceof HTTPMessageImpl) {
            HTTPMessageImpl httpMessage = (HTTPMessageImpl)this.message;
            httpMessage.setXmlFragment(new XMLFragment(source));
        }
        MessageContextAssociation.peekMessageContext().setModified(true);
    }

    public Object getPayload(JAXBContext jaxbContext) {
        Object payload = null;
        if (this.message instanceof SOAPMessage) {
            SOAPMessage soapMessage = (SOAPMessage)this.message;
            SOAPBodyImpl soapBody = this.getSOAPBody(soapMessage);
            SOAPContentElement bodyElement = (SOAPContentElement)this.getBodyElement(soapBody);
            if (bodyElement != null) {
                payload = bodyElement.getObjectValue();
            }
        } else if (this.message instanceof HTTPMessageImpl) {
            throw new NotImplementedException();
        }
        return payload;
    }

    public void setPayload(Object payload, JAXBContext jaxbContext) {
        if (this.message instanceof SOAPMessage) {
            SOAPMessage soapMessage = (SOAPMessage)this.message;
            SOAPBodyImpl soapBody = this.getSOAPBody(soapMessage);
            SOAPContentElement bodyElement = (SOAPContentElement)this.getBodyElement(soapBody);
            if (bodyElement != null) {
                bodyElement.setObjectValue(payload);
                MessageContextAssociation.peekMessageContext().setModified(true);
            }
        } else if (this.message instanceof HTTPMessageImpl) {
            throw new NotImplementedException();
        }
    }

    private SOAPElement getBodyElement(SOAPBodyImpl soapBody) {
        SOAPElement bodyElement = null;
        NodeList nodes = soapBody.getChildNodes();
        for (int i = 0; i < nodes.getLength() && bodyElement == null; ++i) {
            Node current = nodes.item(i);
            if (!(current instanceof SOAPElement)) continue;
            bodyElement = (SOAPElement)current;
        }
        return bodyElement;
    }

    private SOAPBodyImpl getSOAPBody(SOAPMessage soapMessage) {
        SOAPBodyImpl soapBody = null;
        try {
            soapBody = (SOAPBodyImpl)soapMessage.getSOAPBody();
        }
        catch (SOAPException ex) {
            WSException.rethrow(ex);
        }
        return soapBody;
    }
}

