/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.server.netty;

import java.util.LinkedList;
import java.util.List;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.ws.core.server.netty.NettyCallbackHandler;
import org.jboss.ws.core.server.netty.NettyHttpServerImpl;

@ChannelPipelineCoverage(value="one")
public abstract class AbstractNettyRequestHandler
extends SimpleChannelUpstreamHandler {
    private final List<NettyCallbackHandler> callbacks = new LinkedList<NettyCallbackHandler>();

    protected AbstractNettyRequestHandler() {
    }

    public final void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) {
        NettyHttpServerImpl.NETTY_CHANNEL_GROUP.add((Object)ctx.getChannel());
    }

    public final void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        e.getCause().printStackTrace();
        e.getChannel().close();
    }

    public abstract void messageReceived(ChannelHandlerContext var1, MessageEvent var2) throws Exception;

    public final boolean hasMoreCallbacks() {
        return this.callbacks.size() > 0;
    }

    public final NettyCallbackHandler getCallback(String requestPath) {
        for (NettyCallbackHandler handler : this.callbacks) {
            if (!handler.getPath().equals(requestPath)) continue;
            return handler;
        }
        return null;
    }

    public final void registerCallback(NettyCallbackHandler callback) {
        callback.init();
        this.callbacks.add(callback);
    }

    public final void unregisterCallback(NettyCallbackHandler callback) {
        this.callbacks.remove(callback);
        callback.destroy();
    }
}

