/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ResourceBundle;
import javax.xml.soap.SOAPEnvelope;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.DOMUtils;
import org.jboss.ws.common.DOMWriter;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.w3c.dom.Node;

public class SOAPElementWriter {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SOAPElementWriter.class);
    private PrintWriter out;
    private boolean writeXMLDeclaration;
    private String charsetName;

    public SOAPElementWriter(Writer w) {
        this.out = new PrintWriter(w);
    }

    public SOAPElementWriter(OutputStream stream) {
        try {
            this.out = new PrintWriter(new OutputStreamWriter(stream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public SOAPElementWriter(OutputStream stream, String charsetName) {
        try {
            this.out = new PrintWriter(new OutputStreamWriter(stream, charsetName));
            this.charsetName = charsetName;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_ENCODING", (Object[])new Object[]{charsetName}));
        }
    }

    public SOAPElementWriter setWriteXMLDeclaration(boolean writeXMLDeclaration) {
        this.writeXMLDeclaration = writeXMLDeclaration;
        return this;
    }

    public static String writeElement(SOAPElementImpl element, boolean pretty) {
        if (element == null) {
            return null;
        }
        StringWriter strw = new StringWriter();
        new SOAPElementWriter(strw).writeElement(element);
        String xmlStr = strw.toString();
        if (pretty) {
            try {
                xmlStr = DOMWriter.printNode((Node)DOMUtils.parse((String)xmlStr), (boolean)true);
            }
            catch (IOException ex) {
                throw new WSException("Cannot parse xml: " + xmlStr, ex);
            }
        }
        return xmlStr;
    }

    public void writeElement(SOAPElementImpl element) {
        this.writeElementInternal(element);
    }

    private void writeElementInternal(SOAPElementImpl element) {
        if (element != null) {
            try {
                if (this.writeXMLDeclaration && element instanceof SOAPEnvelope) {
                    this.out.print("<?xml version='1.0'");
                    if (this.charsetName != null) {
                        this.out.print(" encoding='" + this.charsetName + "'");
                    }
                    this.out.println("?>");
                    this.writeXMLDeclaration = false;
                }
                element.writeElement(this.out);
                this.out.flush();
            }
            catch (IOException ex) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_WRITE_SOAP_ELEMENT", (Object[])new Object[0]), ex);
            }
        }
    }
}

