/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing.policy;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import org.apache.ws.policy.PrimitiveAssertion;
import org.jboss.ws.api.addressing.AddressingConstants;
import org.jboss.ws.extensions.policy.deployer.domainAssertion.AssertionDeployer;
import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedAssertion;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ExtensibleMetaData;

public class AddressingPolicyAssertionDeployer
implements AssertionDeployer {
    @Override
    public void deployClientSide(PrimitiveAssertion assertion, ExtensibleMetaData extensibleMD) throws UnsupportedAssertion {
        AddressingPolicyAssertionDeployer.deploy(assertion, extensibleMD);
    }

    @Override
    public void deployServerSide(PrimitiveAssertion assertion, ExtensibleMetaData extensibleMD) throws UnsupportedAssertion {
        AddressingPolicyAssertionDeployer.deploy(assertion, extensibleMD);
    }

    private static void deploy(PrimitiveAssertion assertion, ExtensibleMetaData extensibleMD) throws UnsupportedAssertion {
        EndpointMetaData endpointMD;
        AddressingFeature addressingFeature;
        if (extensibleMD instanceof EndpointMetaData && (addressingFeature = (endpointMD = (EndpointMetaData)extensibleMD).getFeature(AddressingFeature.class)) == null) {
            boolean enabled = true;
            boolean required = AddressingPolicyAssertionDeployer.isRequired(assertion);
            AddressingFeature.Responses responses = AddressingPolicyAssertionDeployer.getResponses(assertion);
            endpointMD.addFeature((WebServiceFeature)new AddressingFeature(true, required, responses));
        }
    }

    private static boolean isRequired(PrimitiveAssertion assertion) {
        String optionalValue = assertion.getAttribute(new QName("http://www.w3.org/ns/ws-policy", "Optional"));
        if (optionalValue == null) {
            return true;
        }
        return !Boolean.parseBoolean(optionalValue.toString());
    }

    private static AddressingFeature.Responses getResponses(PrimitiveAssertion assertion) {
        QName assertionQName = assertion.getName();
        if (AddressingConstants.Metadata.Elements.ANONYMOUSRESPONSES_QNAME.equals(assertionQName)) {
            return AddressingFeature.Responses.ANONYMOUS;
        }
        if (AddressingConstants.Metadata.Elements.NONANONYMOUSRESPONSES_QNAME.equals(assertionQName)) {
            return AddressingFeature.Responses.NON_ANONYMOUS;
        }
        List terms = assertion.getTerms();
        if (terms != null) {
            for (Object term : terms) {
                if (!(term instanceof PrimitiveAssertion)) continue;
                return AddressingPolicyAssertionDeployer.getResponses((PrimitiveAssertion)term);
            }
        }
        return AddressingFeature.Responses.ALL;
    }
}

