/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.json;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ResourceBundle;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMSource;
import org.codehaus.jettison.badgerfish.BadgerFishXMLOutputFactory;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.extensions.json.BadgerFishXMLEventWriter;
import org.w3c.dom.Element;

public class BadgerFishDOMDocumentSerializer {
    private static final ResourceBundle bundle = BundleUtils.getBundle(BadgerFishDOMDocumentSerializer.class);
    private OutputStream output;

    public BadgerFishDOMDocumentSerializer(OutputStream output) {
        this.output = output;
    }

    public void serialize(Element el) throws IOException {
        if (this.output == null) {
            throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"OUTPUTSTREAM_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        try {
            DOMSource source = new DOMSource(el);
            XMLInputFactory readerFactory = XMLInputFactory.newInstance();
            XMLStreamReader streamReader = readerFactory.createXMLStreamReader(source);
            XMLEventReader eventReader = readerFactory.createXMLEventReader(streamReader);
            BadgerFishXMLOutputFactory writerFactory = new BadgerFishXMLOutputFactory();
            XMLStreamWriter streamWriter = writerFactory.createXMLStreamWriter(this.output);
            BadgerFishXMLEventWriter eventWriter = new BadgerFishXMLEventWriter(streamWriter);
            eventWriter.add(eventReader);
            eventWriter.close();
        }
        catch (XMLStreamException ex) {
            IOException ioex = new IOException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_SERIALIZE", (Object[])new Object[]{el}));
            ioex.initCause(ex);
            throw ioex;
        }
    }
}

