/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.jws.soap.SOAPMessageHandlers;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.WebServiceProvider;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOMFeature;
import org.jboss.ws.WSException;
import org.jboss.ws.annotation.Documentation;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.IOUtils;
import org.jboss.ws.extensions.policy.annotation.PolicyAttachment;
import org.jboss.ws.extensions.policy.metadata.PolicyMetaDataBuilder;
import org.jboss.ws.metadata.builder.MetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.EndpointFeatureProcessor;
import org.jboss.ws.metadata.builder.jaxws.JAXWSServerMetaDataBuilder;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaDataJAXWS;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLBinding;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsse.WSSecurityConfigFactory;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.tools.wsdl.JAXBWSDLGenerator;
import org.jboss.ws.tools.wsdl.WSDLDefinitionsFactory;
import org.jboss.ws.tools.wsdl.WSDLWriter;
import org.jboss.ws.tools.wsdl.WSDLWriterResolver;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesFactory;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public class JAXWSWebServiceMetaDataBuilder
extends JAXWSServerMetaDataBuilder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JAXWSWebServiceMetaDataBuilder.class);
    private boolean generateWsdl = true;
    private boolean extension;
    private boolean toolMode = false;
    private File wsdlDirectory = null;
    private PrintStream messageStream = null;

    public void setGenerateWsdl(boolean generateWsdl) {
        this.generateWsdl = generateWsdl;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public ServerEndpointMetaData buildWebServiceMetaData(Deployment dep, UnifiedMetaData wsMetaData, Class<?> sepClass, String linkName) {
        try {
            EndpointResult result = this.processWebService(dep, wsMetaData, sepClass, linkName);
            ClassLoader runtimeClassLoader = dep.getRuntimeClassLoader();
            if (null == runtimeClassLoader) {
                throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"RUNTIME_LOADER_CANNOT_BE_NULL", (Object[])new Object[0]));
            }
            this.resetMetaDataBuilder(runtimeClassLoader);
            ServerEndpointMetaData sepMetaData = result.sepMetaData;
            ServiceMetaData serviceMetaData = result.serviceMetaData;
            serviceMetaData.setWsdlLocation(result.wsdlLocation);
            Class seiClass = result.epClass;
            sepMetaData.setLinkName(linkName);
            sepMetaData.setServiceEndpointImplName(sepClass.getName());
            sepMetaData.setServiceEndpointInterfaceName(seiClass.getName());
            WSSecurityConfigFactory wsseConfFactory = WSSecurityConfigFactory.newInstance();
            WSSecurityConfiguration securityConfiguration = wsseConfFactory.createConfiguration(wsMetaData.getRootFile(), "jboss-wsse-server.xml");
            serviceMetaData.setSecurityConfiguration(securityConfiguration);
            this.processSOAPBinding(sepMetaData, seiClass);
            this.processBindingType(sepMetaData, sepClass);
            this.processEndpointConfig(dep, sepMetaData, sepClass, linkName);
            EndpointFeatureProcessor epFeatureProcessor = new EndpointFeatureProcessor();
            epFeatureProcessor.processEndpointFeatures(dep, sepMetaData, sepClass);
            if (seiClass.isAnnotationPresent(Documentation.class)) {
                sepMetaData.setDocumentation(seiClass.getAnnotation(Documentation.class).content());
            }
            if (!this.toolMode) {
                this.processPolicies(serviceMetaData, sepMetaData);
                this.setupOperationsFromWSDL(serviceMetaData, sepMetaData);
            }
            this.processWebMethods(sepMetaData, seiClass);
            this.processXmlSeeAlso(seiClass);
            this.initTransportGuaranteeJSE(dep, sepMetaData, linkName);
            this.createJAXBContext(sepMetaData);
            this.populateXmlTypes(sepMetaData);
            if (sepClass.isAnnotationPresent(PolicyAttachment.class)) {
                PolicyMetaDataBuilder policyBuilder = PolicyMetaDataBuilder.getServerSidePolicyMetaDataBuilder(this.toolMode);
                policyBuilder.processPolicyAnnotations(sepMetaData, sepClass);
            }
            if (this.generateWsdl || !this.toolMode) {
                this.generateWSDL(seiClass, serviceMetaData, sepMetaData);
            }
            if (this.toolMode) {
                return sepMetaData;
            }
            WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
            JBossXSModel schemaModel = WSDLUtils.getSchemaModel(wsdlDefinitions.getWsdlTypes());
            serviceMetaData.getTypesMetaData().setSchemaModel(schemaModel);
            this.processWebContext(dep, sepClass, linkName, sepMetaData);
            sepMetaData.initEndpointConfig();
            if (sepClass.isAnnotationPresent(HandlerChain.class)) {
                this.processHandlerChain(sepMetaData, sepClass);
            } else if (seiClass.isAnnotationPresent(HandlerChain.class)) {
                this.processHandlerChain(sepMetaData, seiClass);
            }
            this.processWSDDContribution(sepMetaData);
            epFeatureProcessor.setupEndpointFeatures(sepMetaData);
            this.initEndpointAddress(dep, sepMetaData);
            if (sepClass.isAnnotationPresent(SOAPMessageHandlers.class) || seiClass.isAnnotationPresent(SOAPMessageHandlers.class)) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"SOAPMESSAGEHANDLERS_IS_DEPRECATED", (Object[])new Object[0]));
            }
            MetaDataBuilder.replaceAddressLocation(sepMetaData);
            ObjectName sepID = MetaDataBuilder.createServiceEndpointID(dep, sepMetaData);
            sepMetaData.setServiceEndpointID(sepID);
            return sepMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            WSException.rethrow("Cannot build meta data: " + ex.getMessage(), ex);
            return null;
        }
    }

    private void processPolicies(ServiceMetaData serviceMetaData, EndpointMetaData epMetaData) {
        URL wsdlLocation = serviceMetaData.getWsdlLocation();
        if (wsdlLocation != null) {
            PolicyMetaDataBuilder policyBuilder = PolicyMetaDataBuilder.getServerSidePolicyMetaDataBuilder(this.toolMode);
            WSDLDefinitionsFactory factory = WSDLDefinitionsFactory.newInstance();
            WSDLDefinitions wsdlDefinitions = factory.parse(wsdlLocation);
            policyBuilder.processPolicyExtensions(epMetaData, wsdlDefinitions);
            serviceMetaData.setWsdlLocation(wsdlLocation);
        }
    }

    private void setupOperationsFromWSDL(ServiceMetaData serviceMetaData, EndpointMetaData epMetaData) {
        WSDLDefinitions wsdlDefinitions = serviceMetaData.getWsdlDefinitions();
        if (wsdlDefinitions == null) {
            return;
        }
        QName serviceName = serviceMetaData.getServiceName();
        WSDLService wsdlService = null;
        if (serviceName == null) {
            if (wsdlDefinitions.getServices().length != 1) {
                throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"EXPECTED_A_SINGLE_SERVICE_ELEMENT", (Object[])new Object[0]));
            }
            wsdlService = wsdlDefinitions.getServices()[0];
            serviceMetaData.setServiceName(wsdlService.getName());
        } else {
            wsdlService = wsdlDefinitions.getService(serviceName);
        }
        if (wsdlService == null) {
            ArrayList<QName> serviceNames = new ArrayList<QName>();
            for (WSDLService wsdls : wsdlDefinitions.getServices()) {
                serviceNames.add(wsdls.getName());
            }
            log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_WSDL_SERVICE", (Object[])new Object[]{serviceName, serviceNames}));
            return;
        }
        WSDLEndpoint wsdlEndpoint = this.getWsdlEndpoint(wsdlDefinitions, epMetaData.getPortName());
        if (wsdlEndpoint == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_FIND_PORT_IN_WSDL", (Object[])new Object[]{epMetaData.getPortName()}));
        }
        QName bindingName = wsdlEndpoint.getBinding();
        WSDLBinding wsdlBinding = wsdlEndpoint.getWsdlService().getWsdlDefinitions().getBinding(bindingName);
        String bindingType = wsdlBinding.getType();
        if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(bindingType) || "http://schemas.xmlsoap.org/wsdl/soap12/".equals(bindingType)) {
            this.setupOperationsFromWSDL(epMetaData, wsdlEndpoint);
        }
    }

    private WSDLEndpoint getWsdlEndpoint(WSDLDefinitions wsdlDefinitions, QName portName) {
        WSDLEndpoint wsdlEndpoint = null;
        for (WSDLService wsdlService : wsdlDefinitions.getServices()) {
            WSDLEndpoint auxEndpoint = wsdlService.getEndpoint(portName);
            if (auxEndpoint == null) continue;
            wsdlEndpoint = auxEndpoint;
            break;
        }
        return wsdlEndpoint;
    }

    private void processWSDDContribution(ServerEndpointMetaData sepMetaData) {
        WebservicesMetaData webservices = WebservicesFactory.loadFromVFSRoot((UnifiedVirtualFile)sepMetaData.getRootFile());
        if (webservices != null) {
            for (WebserviceDescriptionMetaData wsDesc : webservices.getWebserviceDescriptions()) {
                for (PortComponentMetaData portComp : wsDesc.getPortComponents()) {
                    MTOMFeature feature;
                    UnifiedHandlerChainsMetaData chainWrapper;
                    boolean doesMatch;
                    String portCompSEI = portComp.getServiceEndpointInterface();
                    boolean bl = doesMatch = portCompSEI != null ? portCompSEI.equals(sepMetaData.getServiceEndpointInterfaceName()) : false;
                    if (!doesMatch) {
                        doesMatch = portComp.getWsdlPort().equals(sepMetaData.getPortName());
                    }
                    if (!doesMatch) continue;
                    log.debug((Object)"Processing 'webservices.xml' contributions on EndpointMetaData");
                    if (portComp.getWsdlPort() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Override EndpointMetaData portName " + sepMetaData.getPortName() + " with " + portComp.getWsdlPort()));
                        }
                        sepMetaData.setPortName(portComp.getWsdlPort());
                    }
                    if ((chainWrapper = portComp.getHandlerChains()) != null) {
                        for (UnifiedHandlerChainMetaData handlerChain : chainWrapper.getHandlerChains()) {
                            for (UnifiedHandlerMetaData uhmd : handlerChain.getHandlers()) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Contribute handler from webservices.xml: " + uhmd.getHandlerName()));
                                }
                                HandlerMetaDataJAXWS hmd = HandlerMetaDataJAXWS.newInstance(uhmd, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
                                sepMetaData.addHandler(hmd);
                            }
                        }
                    }
                    if (portComp.isMtomEnabled()) {
                        log.debug((Object)"Enabling MTOM");
                        feature = new MTOMFeature(true, portComp.getMtomThreshold());
                        sepMetaData.getFeatures().addFeature((WebServiceFeature)feature);
                    }
                    if (portComp.isAddressingEnabled()) {
                        log.debug((Object)"Enabling Addressing");
                        AddressingFeature.Responses responses = this.getAddressFeatureResponses(portComp.getAddressingResponses());
                        AddressingFeature feature2 = new AddressingFeature(true, portComp.isAddressingRequired(), responses);
                        sepMetaData.getFeatures().addFeature((WebServiceFeature)feature2);
                    }
                    if (!portComp.isRespectBindingEnabled()) continue;
                    log.debug((Object)"Enabling RespectBinding Feature");
                    feature = new RespectBindingFeature(true);
                    sepMetaData.getFeatures().addFeature((WebServiceFeature)feature);
                }
            }
        }
    }

    private EndpointResult processWebService(Deployment dep, UnifiedMetaData wsMetaData, Class<?> sepClass, String linkName) throws ClassNotFoundException, IOException {
        String portName;
        String serviceNS;
        String serviceName;
        String name;
        WebService anWebService = sepClass.getAnnotation(WebService.class);
        WebServiceProvider anWebServiceProvider = sepClass.getAnnotation(WebServiceProvider.class);
        if (anWebService == null && anWebServiceProvider == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_ANNOTATION", (Object[])new Object[]{sepClass.getName()}));
        }
        Endpoint ep = dep.getService().getEndpointByName(linkName);
        Class<?> seiClass = null;
        WSDLUtils wsdlUtils = WSDLUtils.getInstance();
        String string = name = anWebService != null ? anWebService.name() : "";
        if (name.length() == 0) {
            name = WSDLUtils.getJustClassName(sepClass);
        }
        String string2 = serviceName = anWebService != null ? anWebService.serviceName() : anWebServiceProvider.serviceName();
        if (serviceName.length() == 0) {
            serviceName = WSDLUtils.getJustClassName(sepClass) + "Service";
        }
        String string3 = serviceNS = anWebService != null ? anWebService.targetNamespace() : anWebServiceProvider.targetNamespace();
        if (serviceNS.length() == 0) {
            serviceNS = WSDLUtils.getTypeNamespace(sepClass);
        }
        String string4 = portName = anWebService != null ? anWebService.portName() : anWebServiceProvider.portName();
        if (portName.length() == 0) {
            portName = name + "Port";
        }
        String wsdlLocation = anWebService != null ? anWebService.wsdlLocation() : anWebServiceProvider.wsdlLocation();
        String interfaceNS = serviceNS;
        if (anWebService != null && anWebService.endpointInterface().length() > 0) {
            String seiName = anWebService.endpointInterface();
            ClassLoader runtimeClassLoader = dep.getRuntimeClassLoader();
            if (null == runtimeClassLoader) {
                throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"RUNTIME_LOADER_CANNOT_BE_NULL", (Object[])new Object[0]));
            }
            seiClass = runtimeClassLoader.loadClass(seiName);
            WebService seiAnnotation = seiClass.getAnnotation(WebService.class);
            if (seiAnnotation == null) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"DOES_NOT_HAVE_WEBSERVICE_ANNOTATION", (Object[])new Object[]{seiName}));
            }
            if (seiAnnotation.portName().length() > 0 || seiAnnotation.serviceName().length() > 0 || seiAnnotation.endpointInterface().length() > 0) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)("CANNOT_HAVE_ATTRIBUTES" + seiName), (Object[])new Object[0]));
            }
            name = seiAnnotation.name();
            if (name.length() == 0) {
                name = WSDLUtils.getJustClassName(seiClass);
            }
            if ((interfaceNS = seiAnnotation.targetNamespace()).length() == 0) {
                interfaceNS = WSDLUtils.getTypeNamespace(seiClass);
            }
            if (wsdlLocation.length() == 0) {
                wsdlLocation = seiAnnotation.wsdlLocation();
            }
        }
        QName portQName = new QName(serviceNS, portName);
        QName portTypeQName = new QName(interfaceNS, name);
        EndpointResult result = new EndpointResult();
        result.serviceMetaData = new ServiceMetaData(wsMetaData, new QName(serviceNS, serviceName));
        result.sepMetaData = new ServerEndpointMetaData(result.serviceMetaData, ep, portQName, portTypeQName, EndpointMetaData.Type.JAXWS);
        result.epClass = seiClass != null ? seiClass : sepClass;
        result.serviceMetaData.addEndpoint(result.sepMetaData);
        wsMetaData.addService(result.serviceMetaData);
        if (dep instanceof ArchiveDeployment) {
            result.wsdlLocation = ((ArchiveDeployment)dep).getResourceResolver().resolve(wsdlLocation);
        }
        return result;
    }

    private void generateWSDL(Class wsClass, ServiceMetaData serviceMetaData, EndpointMetaData epMetaData) {
        URL wsdlLocation = serviceMetaData.getWsdlLocation();
        if (wsdlLocation == null) {
            try {
                JAXBWSDLGenerator generator = new JAXBWSDLGenerator(this.jaxbCtx);
                generator.setExtension(this.extension);
                WSDLDefinitions wsdlDefinitions = generator.generate(serviceMetaData);
                this.writeWsdl(serviceMetaData, wsdlDefinitions, epMetaData);
            }
            catch (IOException e) {
                throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_WRITE_GENERATED_WSDL", (Object[])new Object[0]), e);
            }
        }
    }

    private void writeWsdl(ServiceMetaData serviceMetaData, WSDLDefinitions wsdlDefinitions, EndpointMetaData epMetaData) throws IOException {
        File wsdlFile;
        File dir;
        String wsdlName = ToolsUtils.firstLetterUpperCase(serviceMetaData.getServiceName().getLocalPart());
        wsdlDefinitions.getWsdlTypes().setNamespace(epMetaData.getPortTypeName().getNamespaceURI());
        if (this.wsdlDirectory != null) {
            dir = this.wsdlDirectory;
            wsdlFile = new File(dir, wsdlName + ".wsdl");
        } else {
            dir = IOUtils.createTempDirectory();
            wsdlFile = File.createTempFile(wsdlName, ".wsdl", dir);
            wsdlFile.deleteOnExit();
        }
        this.message(wsdlFile.getName());
        Writer writer = IOUtils.getCharsetFileWriter((File)wsdlFile, (String)"UTF-8");
        new WSDLWriter(wsdlDefinitions).write(writer, "UTF-8", new WSDLWriterResolver(){

            @Override
            public WSDLWriterResolver resolve(String suggestedFile) throws IOException {
                File file;
                if (JAXWSWebServiceMetaDataBuilder.this.wsdlDirectory != null) {
                    file = new File(dir, suggestedFile + ".wsdl");
                } else {
                    file = File.createTempFile(suggestedFile, ".wsdl", dir);
                    file.deleteOnExit();
                }
                this.actualFile = file.getName();
                JAXWSWebServiceMetaDataBuilder.this.message(this.actualFile);
                this.charset = "UTF-8";
                this.writer = IOUtils.getCharsetFileWriter((File)file, (String)"UTF-8");
                return this;
            }
        });
        writer.close();
        serviceMetaData.setWsdlLocation(wsdlFile.toURL());
    }

    private void message(String msg) {
        if (this.messageStream != null) {
            this.messageStream.println(msg);
        }
    }

    public void setToolMode(boolean toolMode) {
        this.toolMode = toolMode;
    }

    public void setWsdlDirectory(File wsdlDirectory) {
        this.wsdlDirectory = wsdlDirectory;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    private static class EndpointResult {
        private Class<?> epClass;
        private ServerEndpointMetaData sepMetaData;
        private ServiceMetaData serviceMetaData;
        private URL wsdlLocation;
        private URL policyLocation;

        private EndpointResult() {
        }
    }
}

