/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.config.jaxrpc;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ws.metadata.config.EndpointProperty;
import org.jboss.wsf.spi.metadata.config.AbstractCommonConfig;
import org.jboss.wsf.spi.metadata.config.Feature;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;

public abstract class CommonConfigJAXRPC
extends AbstractCommonConfig {
    private List<EndpointProperty> properties = new ArrayList<EndpointProperty>();

    public UnifiedHandlerChainMetaData getPostHandlerChain() {
        List chains = this.getPostHandlerChains();
        if (chains != null && !chains.isEmpty()) {
            return (UnifiedHandlerChainMetaData)chains.get(0);
        }
        return null;
    }

    public void setPostHandlerChain(UnifiedHandlerChainMetaData postHandlerChain) {
        ArrayList<UnifiedHandlerChainMetaData> chains = new ArrayList<UnifiedHandlerChainMetaData>(1);
        chains.add(postHandlerChain);
        this.setPostHandlerChains(chains);
    }

    public UnifiedHandlerChainMetaData getPreHandlerChain() {
        List chains = this.getPreHandlerChains();
        if (chains != null && !chains.isEmpty()) {
            return (UnifiedHandlerChainMetaData)chains.get(0);
        }
        return null;
    }

    public void setPreHandlerChain(UnifiedHandlerChainMetaData preHandlerChain) {
        ArrayList<UnifiedHandlerChainMetaData> chains = new ArrayList<UnifiedHandlerChainMetaData>(1);
        chains.add(preHandlerChain);
        this.setPreHandlerChains(chains);
    }

    public boolean hasFeature(URI type) {
        return this.hasFeature(type.toString());
    }

    public boolean hasFeature(String uri) {
        return super.hasFeature(uri);
    }

    public void setFeature(String type, boolean enabled) {
        super.setFeature(new Feature(type), enabled);
    }

    public void setProperty(String name, String value) {
        this.addProperty(name, value);
    }

    public void addProperty(String name, String value) {
        EndpointProperty p = new EndpointProperty();
        p.name = CommonConfigJAXRPC.nameToURI(name);
        p.value = value;
        this.properties.add(p);
        super.setProperty(name, value);
    }

    public String getProperty(String name) {
        String value = null;
        URI uri = CommonConfigJAXRPC.nameToURI(name);
        for (EndpointProperty wsp : this.properties) {
            if (!wsp.name.equals(uri)) continue;
            value = wsp.value;
            break;
        }
        return value;
    }

    public List<EndpointProperty> getAllProperties() {
        return this.properties;
    }

    private static URI nameToURI(String name) {
        URI uri = null;
        try {
            uri = new URI(name);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return uri;
    }
}

