/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.rmi.Remote;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.ByteArrayHolder;
import javax.xml.rpc.holders.Holder;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.Constants;
import org.jboss.ws.common.JavaUtils;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.core.jaxrpc.binding.SimpleDeserializerFactory;
import org.jboss.ws.core.jaxrpc.binding.SimpleSerializerFactory;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;

public class ToolsUtils {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ToolsUtils.class);
    private static LiteralTypeMapping mapping = new LiteralTypeMapping();

    private ToolsUtils() {
        throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_INSTANTIATE_TOOLSUTILS", (Object[])new Object[0]));
    }

    public static void checkParameterType(Class paramType) {
        if (Remote.class.isAssignableFrom(paramType)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"METHOD_PARAM_SHOULDN_NOT_EXTEND_REMOTE", (Object[])new Object[0]));
        }
    }

    public static String firstLetterUpperCase(String fname) {
        if (fname == null || fname.length() == 0) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"STRING_PASSED_IS_NULL", (Object[])new Object[0]));
        }
        if (Character.isLowerCase(fname.charAt(0))) {
            char f;
            char[] chars = fname.toCharArray();
            chars[0] = f = Character.toUpperCase(chars[0]);
            fname = new String(chars);
        }
        return fname;
    }

    public static String firstLetterLowerCase(String fname) {
        if (fname == null || fname.length() == 0) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"STRING_PASSED_IS_NULL", (Object[])new Object[0]));
        }
        if (Character.isUpperCase(fname.charAt(0))) {
            char f;
            char[] chars = fname.toCharArray();
            chars[0] = f = Character.toLowerCase(chars[0]);
            fname = new String(chars);
        }
        return fname;
    }

    public static String getJavaIdentifier(String xmlName) {
        if (xmlName == null || xmlName.length() == 0) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"XMLNAME_IS_NULL", (Object[])new Object[0]));
        }
        xmlName = xmlName.trim();
        if ((xmlName = ToolsUtils.trimPunctuationMarks(xmlName)) == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"XMLNAME_IS_NULL", (Object[])new Object[0]));
        }
        int lenStr = xmlName.length();
        char[] mainArr = new char[lenStr];
        int j = 0;
        for (int i = 0; i < lenStr; ++i) {
            char ch = xmlName.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            mainArr[j] = ch;
            ++j;
        }
        char[] secArr = new char[j];
        for (int x = 0; x < j; ++x) {
            secArr[x] = mainArr[x];
        }
        return new String(secArr);
    }

    public static String getJavaMethodName(String xmlName, boolean setter) {
        xmlName = ToolsUtils.getJavaIdentifier(xmlName);
        xmlName = ToolsUtils.firstLetterUpperCase(xmlName);
        String lcase = xmlName.toLowerCase();
        if (setter && !lcase.startsWith("set")) {
            xmlName = "set" + xmlName;
        } else if (!setter && !lcase.startsWith("get")) {
            xmlName = "get" + xmlName;
        }
        return ToolsUtils.firstLetterLowerCase(xmlName);
    }

    public static String getValidClassName(String xmlName) {
        xmlName = ToolsUtils.getJavaIdentifier(xmlName);
        return ToolsUtils.firstLetterUpperCase(xmlName);
    }

    public static QName getXMLType(Class javaClass, String ns) {
        WSDLUtils utils = WSDLUtils.getInstance();
        QName xmlType = null;
        if (Void.TYPE == javaClass) {
            return null;
        }
        if (ByteArrayHolder.class == javaClass) {
            return Constants.TYPE_LITERAL_BASE64BINARY;
        }
        if (Holder.class.isAssignableFrom(javaClass)) {
            javaClass = utils.getJavaTypeForHolder(javaClass);
        }
        if ((xmlType = SchemaUtils.getInstance().getToolsOverrideInTypeMapping(javaClass)) != null) {
            return xmlType;
        }
        if (javaClass != Byte[].class && javaClass != String[].class && (xmlType = mapping.getXMLType(javaClass, false)) != null) {
            return xmlType;
        }
        String typeName = WSDLUtils.getJustClassName(javaClass);
        if (javaClass.isArray()) {
            int dim = utils.getArrayDimension(javaClass);
            Class<?> cls = javaClass;
            while (cls.isArray()) {
                cls = cls.getComponentType();
            }
            WSDLUtils.getInstance();
            typeName = WSDLUtils.getJustClassName(cls);
            while (dim-- > 0) {
                typeName = typeName + ".Array";
            }
        }
        return new QName(ns, typeName);
    }

    public static QName getXMLTypeForAttachmentType(String mimetype) {
        return Constants.TYPE_LITERAL_HEXBINARY;
    }

    public static boolean isPunctuation(char c) {
        boolean ret = true;
        if (Character.isDigit(c)) {
            ret = false;
        } else if (Character.isLetter(c)) {
            ret = false;
        } else if (Character.isISOControl(c)) {
            ret = false;
        } else if (Character.isWhitespace(c)) {
            ret = false;
        }
        return ret;
    }

    public static boolean isJaxrpcValueType(Class cls) {
        boolean result = true;
        if (ToolsUtils.isJaxrpcRegularType(cls)) {
            return false;
        }
        boolean defaultCTR = false;
        Constructor<?>[] cons = cls.getDeclaredConstructors();
        for (int i = 0; i < cons.length; ++i) {
            Class<?>[] paramTypes = cons[i].getParameterTypes();
            if (paramTypes != null && paramTypes.length != 0) continue;
            defaultCTR = true;
            break;
        }
        if (!defaultCTR) {
            return false;
        }
        if (Remote.class.isAssignableFrom(cls)) {
            return false;
        }
        Field[] fieldArr = cls.getDeclaredFields();
        int length = Array.getLength(fieldArr);
        for (int i = 0; i < length; ++i) {
            if (ToolsUtils.isJaxrpcPermittedType(fieldArr[i].getType())) continue;
            return false;
        }
        return result;
    }

    public static boolean isJavaBean(Class cls) {
        boolean result = false;
        if (ToolsUtils.isJaxrpcRegularType(cls)) {
            return false;
        }
        try {
            BeanInfo bi = Introspector.getBeanInfo(cls);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            if (pds != null && pds.length > 0) {
                result = true;
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return result;
    }

    public static int getNumberOfParticles(Class javaBean) {
        if (!ToolsUtils.isJavaBean(javaBean)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ILLEGAL_JAVABEAN_ARGUMENT", (Object[])new Object[0]));
        }
        Field[] pubFields = javaBean.getFields();
        int pub = pubFields != null ? pubFields.length : 0;
        int props = 0;
        try {
            BeanInfo bi = Introspector.getBeanInfo(javaBean);
            PropertyDescriptor[] pds = bi.getPropertyDescriptors();
            props = pds != null ? Array.getLength(pds) : 0;
            int len = 0;
            for (int i = 0; i < props; ++i) {
                PropertyDescriptor pd = pds[i];
                Method readMethod = pd.getReadMethod();
                if ("getClass".equals(readMethod.getName())) continue;
                ++len;
            }
            props = len;
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
        return pub + props;
    }

    public static boolean canUnWrap(Class javaType, boolean isReturnType) {
        boolean bool = false;
        bool = isReturnType ? ToolsUtils.isJavaBean(javaType) && ToolsUtils.getNumberOfParticles(javaType) == 1 : ToolsUtils.isJaxrpcValueType(javaType);
        return bool;
    }

    public static boolean isJaxrpcPermittedType(Class type) {
        if (!ToolsUtils.isJaxrpcRegularType(type)) {
            return ToolsUtils.isJaxrpcValueType(type);
        }
        return true;
    }

    public static boolean isJaxrpcRegularType(Class type) {
        boolean result = false;
        if (JavaUtils.isPrimitive((Class)type)) {
            return true;
        }
        Class wrapperType = JavaUtils.getWrapperType((Class)type);
        if (wrapperType != null && wrapperType != type) {
            return true;
        }
        Class primType = JavaUtils.getPrimitiveType((Class)type);
        if (primType != null && primType != type) {
            return true;
        }
        if (String.class == type || Date.class == type || Calendar.class == type || BigInteger.class == type || BigDecimal.class == type || QName.class == type || URI.class == type) {
            return true;
        }
        return result;
    }

    public static synchronized void registerJavaType(LiteralTypeMapping typeMapping, Class clazz, QName xmlType) {
        if (!typeMapping.isRegistered(clazz, xmlType)) {
            typeMapping.register(clazz, xmlType, new SimpleSerializerFactory(), new SimpleDeserializerFactory());
        }
    }

    public static String convertInvalidCharacters(String component) {
        String result = component;
        for (int i = 0; i < result.length(); ++i) {
            if (Character.isJavaIdentifierPart(result.charAt(i))) continue;
            result = result.replace(result.charAt(i), '_');
        }
        return result;
    }

    private static String trimPunctuationMarks(String str) {
        if (str == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"STR_IS_NULL", (Object[])new Object[0]));
        }
        if (!Character.isJavaIdentifierStart(str.charAt(0))) {
            str = str.substring(1);
        } else if (ToolsUtils.isPunctuation(str.charAt(0))) {
            str = str.substring(1);
        }
        int len = str.length();
        if (ToolsUtils.isPunctuation(str.charAt(len - 1))) {
            str = str.substring(0, len - 1);
        }
        return str;
    }
}

