/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.metadata;

import java.rmi.Remote;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.ResourceLoaderAdapter;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.metadata.ReflectiveMetaDataBuilder;
import org.jboss.ws.tools.metadata.SecurityActions;
import org.jboss.ws.tools.metadata.ToolsEndpointMetaData;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;

public class ToolsUnifiedMetaDataBuilder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(ToolsUnifiedMetaDataBuilder.class);
    private static Logger log = Logger.getLogger(ToolsUnifiedMetaDataBuilder.class);
    private Class seiClass;
    private UnifiedMetaData um;
    private String targetNamespace = null;
    private String typeNamespace = null;
    private String serviceName = null;
    private Map<String, List<Configuration.OperationConfig>> operationMap = null;
    private Style style;
    private SOAPBinding.ParameterStyle parameterStyle;

    public ToolsUnifiedMetaDataBuilder(Class epClass, String targetNamespace, String typeNamespace, String serviceName, Style style, SOAPBinding.ParameterStyle parameterStyle, Map<String, List<Configuration.OperationConfig>> operationMap) {
        this.seiClass = epClass;
        this.targetNamespace = targetNamespace;
        this.typeNamespace = typeNamespace != null ? typeNamespace : targetNamespace;
        this.serviceName = serviceName;
        this.style = style;
        this.parameterStyle = parameterStyle;
        this.operationMap = operationMap;
        this.buildMetaData();
    }

    public UnifiedMetaData getUnifiedMetaData() {
        return this.um;
    }

    private void buildMetaData() {
        if (!Remote.class.isAssignableFrom(this.seiClass)) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"SEI_MUST_EXTEND_REMOTE", (Object[])new Object[]{this.seiClass.getName()}));
        }
        ClassLoader contextClassLoader = SecurityActions.getContextClassLoader();
        ResourceLoaderAdapter vfsRoot = new ResourceLoaderAdapter();
        this.um = new UnifiedMetaData((UnifiedVirtualFile)vfsRoot);
        this.um.setClassLoader(contextClassLoader);
        WSDLUtils.getInstance();
        String seiName = WSDLUtils.getJustClassName(this.seiClass.getName());
        if (this.serviceName == null) {
            this.serviceName = seiName + "Service";
        }
        this.um.addService(this.getServiceMetaData(this.um, this.targetNamespace, this.serviceName, seiName, this.seiClass));
        this.generateOperationMetaData(this.seiClass);
    }

    private void generateOperationMetaData(Class seiClass) {
        ServiceMetaData sm = this.um.getServices().get(0);
        ToolsEndpointMetaData em = (ToolsEndpointMetaData)sm.getEndpointByServiceEndpointInterface(seiClass.getName());
        if (em == null) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"ENDPOINTMETADATA_IS_NULL", (Object[])new Object[0]));
        }
        ReflectiveMetaDataBuilder rmb = new ReflectiveMetaDataBuilder(em);
        rmb.setOperationMap(this.operationMap);
        em = rmb.generate();
    }

    private ServiceMetaData getServiceMetaData(UnifiedMetaData um, String targetNamespace, String serviceName, String portTypeName, Class seiClass) {
        ServiceMetaData sm = new ServiceMetaData(um, new QName(targetNamespace, serviceName));
        QName name = new QName(targetNamespace, portTypeName + "Port");
        QName interfaceName = new QName(targetNamespace, portTypeName);
        ToolsEndpointMetaData tm = new ToolsEndpointMetaData(sm, name, interfaceName);
        tm.typeNamespace = this.typeNamespace;
        tm.setServiceEndpointInterfaceName(seiClass.getName());
        tm.setStyle(this.style);
        tm.setParameterStyle(this.parameterStyle);
        sm.addEndpoint(tm);
        return sm;
    }
}

