/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import java.security.Principal;
import java.util.ResourceBundle;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxws.wsaddressing.EndpointReferenceUtil;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.wsf.spi.invocation.ExtensibleWebServiceContext;
import org.w3c.dom.Element;

public final class NativeWebServiceContext
extends ExtensibleWebServiceContext {
    private static final ResourceBundle bundle = BundleUtils.getBundle(NativeWebServiceContext.class);

    public NativeWebServiceContext(MessageContext messageContext) {
        super(messageContext);
    }

    public EndpointReference getEndpointReference(Element ... referenceParameters) {
        return this.getEndpointReference(W3CEndpointReference.class, referenceParameters);
    }

    public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
        EndpointMetaData endpointMD = ((CommonMessageContext)this.getMessageContext()).getEndpointMetaData();
        if (endpointMD == null) {
            throw new WebServiceException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_OBTAIN_ENDPOINTMD", (Object[])new Object[0]));
        }
        if ("http://www.w3.org/2004/08/wsdl/http".equals(endpointMD.getBindingId())) {
            throw new UnsupportedOperationException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_GET_EPR", (Object[])new Object[0]));
        }
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        String address = endpointMD.getEndpointAddress();
        builder.address(address);
        builder.wsdlDocumentLocation(address + "?wsdl");
        builder.serviceName(endpointMD.getServiceMetaData().getServiceName());
        builder.endpointName(endpointMD.getPortName());
        if (referenceParameters != null && W3CEndpointReference.class.getName().equals(clazz.getName())) {
            for (Element el : referenceParameters) {
                builder.referenceParameter(el);
            }
        }
        return EndpointReferenceUtil.transform(clazz, (EndpointReference)builder.build());
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }
}

