/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.builder.runtime;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.logging.Logger;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.builder.runtime.AbstractPropertyHandler;
import org.jboss.xb.builder.runtime.BuilderUtil;
import org.jboss.xb.spi.BeanAdapter;
import org.jboss.xb.spi.BeanAdapterFactory;
import org.xml.sax.Attributes;

public class GroupBeanHandler
implements ParticleHandler {
    protected static final Logger log = Logger.getLogger((String)"org.jboss.xb.builder.runtime.GroupBeanHandler");
    protected boolean trace = log.isTraceEnabled();
    protected String name;
    protected BeanAdapterFactory beanAdapterFactory;
    protected QName groupName;

    public GroupBeanHandler(String name, BeanAdapterFactory beanAdapterFactory, ModelGroupBinding group) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (beanAdapterFactory == null) {
            throw new IllegalArgumentException("Null bean adapter factory");
        }
        if (group == null) {
            throw new IllegalArgumentException("Null group");
        }
        if (group.getQName() == null) {
            throw new JBossXBRuntimeException("The group has to have a non-null QName.");
        }
        this.name = name;
        this.beanAdapterFactory = beanAdapterFactory;
        this.groupName = group.getQName();
    }

    public Object startParticle(Object parent, QName qName, ParticleBinding particle, Attributes attrs, NamespaceContext nsCtx) {
        if (this.trace) {
            log.trace((Object)(" startElement " + qName + " bean=" + this.name + " parent=" + BuilderUtil.toDebugString(parent)));
        }
        if (!(parent instanceof BeanAdapter)) {
            throw new JBossXBRuntimeException("Parent expected to be an instance of BeanAdapter: " + parent);
        }
        AbstractPropertyHandler groupHandler = ((BeanAdapter)parent).getPropertyHandler(this.groupName);
        if (groupHandler == null) {
            throw new JBossXBRuntimeException("No property mapped for group " + qName + " in bean adapter" + ((BeanAdapter)parent).getValue() + ", available: " + ((BeanAdapter)parent).getAvailable());
        }
        Object groupValue = null;
        PropertyInfo propertyInfo = groupHandler.getPropertyInfo();
        if (propertyInfo.isReadable()) {
            Object parentValue = ((BeanAdapter)parent).getValue();
            try {
                groupValue = ((BeanAdapter)parent).get(propertyInfo);
            }
            catch (Throwable e) {
                throw new JBossXBRuntimeException("Failed to get group value from parent: parent=" + parentValue + ", property=" + propertyInfo.getName() + ", qName=" + qName, e);
            }
        }
        if (groupValue == null || particle.isRepeatable()) {
            try {
                return this.beanAdapterFactory.newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException("Element " + qName + " (group " + this.groupName + ") error invoking beanAdapterFactory.newInstance() for bean=" + this.name, t);
            }
        }
        return new SingletonBeanAdapter(this.beanAdapterFactory, groupValue);
    }

    public void setParent(Object parent, Object o, QName qName, ParticleBinding particle, ParticleBinding parentParticle) {
        BeanAdapter beanAdapter;
        AbstractPropertyHandler propertyHandler;
        if (this.trace) {
            log.trace((Object)("setParent " + qName + " parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o)));
        }
        if ((propertyHandler = (beanAdapter = (BeanAdapter)parent).getPropertyHandler(this.groupName)) == null) {
            if (particle.getTerm().getSchema().isStrictSchema()) {
                throw new RuntimeException("QName " + qName + " unknown property parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o) + " available=" + beanAdapter.getAvailable());
            }
            if (this.trace) {
                log.trace((Object)("QName " + qName + " unknown property parent=" + BuilderUtil.toDebugString(parent) + " child=" + BuilderUtil.toDebugString(o)));
            }
            return;
        }
        propertyHandler.doHandle(beanAdapter, o, qName);
    }

    public Object endParticle(Object o, QName qName, ParticleBinding particle) {
        ValueAdapter valueAdapter;
        if (this.trace) {
            log.trace((Object)("endElement " + qName + " o=" + BuilderUtil.toDebugString(o)));
        }
        BeanAdapter beanAdapter = (BeanAdapter)o;
        Object value = beanAdapter.getValue();
        if (!particle.isRepeatable() && (valueAdapter = particle.getTerm().getValueAdapter()) != null) {
            value = valueAdapter.cast(value, null);
        }
        return value;
    }

    private static class SingletonBeanAdapter
    extends BeanAdapter {
        private final Object value;

        public SingletonBeanAdapter(BeanAdapterFactory beanAdapterFactory, Object instance) {
            super(beanAdapterFactory);
            this.value = instance;
        }

        protected Object construct() {
            return this.value;
        }

        public Object get(PropertyInfo propertyInfo) throws Throwable {
            return propertyInfo.get(this.value);
        }

        public Object getValue() {
            return this.value;
        }

        public void set(PropertyInfo propertyInfo, Object child) throws Throwable {
            propertyInfo.set(this.value, child);
        }
    }
}

