/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.security.AccessController;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.network.SocketBindingManagerImpl;
import org.jboss.as.server.Services;
import org.jboss.as.server.mgmt.HttpManagementResourceDefinition;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossThreadFactory;

public class HttpManagementAddHandler
extends AbstractAddStepHandler {
    public static final HttpManagementAddHandler INSTANCE = new HttpManagementAddHandler();
    public static final String OPERATION_NAME = "add";

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition definition : HttpManagementResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            HttpManagementAddHandler.validateAndSet(definition, operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        HttpManagementAddHandler.installHttpManagementConnector(context, model, context.getServiceTarget(), verificationHandler, newControllers);
    }

    private static void validateAndSet(AttributeDefinition definition, ModelNode operation, ModelNode subModel) throws OperationFailedException {
        String attributeName = definition.getName();
        boolean has = operation.has(attributeName);
        if (!has && definition.isRequired(operation)) {
            throw new OperationFailedException(new ModelNode().set(attributeName + " is required"));
        }
        if (has) {
            if (!definition.isAllowed(operation)) {
                throw new OperationFailedException(new ModelNode().set(attributeName + " is invalid"));
            }
            definition.validateAndSet(operation, subModel);
        } else {
            subModel.get(definition.getName());
        }
    }

    private static ModelNode validateResolvedModel(AttributeDefinition definition, OperationContext context, ModelNode subModel) throws OperationFailedException {
        ModelNode result;
        String attributeName = definition.getName();
        boolean has = subModel.has(attributeName);
        if (!has && definition.isRequired(subModel)) {
            throw new OperationFailedException(new ModelNode().set(String.format("%s is required", attributeName)));
        }
        if (has) {
            if (!definition.isAllowed(subModel)) {
                if (subModel.hasDefined(attributeName)) {
                    throw new OperationFailedException(new ModelNode().set(String.format("%s is not allowed when [%s] are present", attributeName, definition.getAlternatives())));
                }
                result = new ModelNode();
            } else {
                result = definition.resolveModelAttribute(context, subModel);
            }
        } else {
            result = new ModelNode();
        }
        return result;
    }

    static void installHttpManagementConnector(OperationContext context, ModelNode model, ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName socketBindingServiceName = null;
        ServiceName secureSocketBindingServiceName = null;
        ServiceName interfaceSvcName = null;
        int port = -1;
        int securePort = -1;
        ModelNode interfaceModelNode = HttpManagementAddHandler.validateResolvedModel((AttributeDefinition)HttpManagementResourceDefinition.INTERFACE, context, model);
        if (interfaceModelNode.isDefined()) {
            String interfaceName = interfaceModelNode.asString();
            interfaceSvcName = NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName});
            ModelNode portNode = HttpManagementResourceDefinition.HTTP_PORT.resolveModelAttribute(context, model);
            port = portNode.isDefined() ? portNode.asInt() : -1;
            ModelNode securePortNode = HttpManagementResourceDefinition.HTTPS_PORT.resolveModelAttribute(context, model);
            securePort = securePortNode.isDefined() ? securePortNode.asInt() : -1;
            StringBuilder sb = new StringBuilder();
            sb.append("Creating http management service using network interface (").append(interfaceName).append(")");
            if (port > -1) {
                sb.append(" port (").append(port).append(")");
            }
            if (securePort > -1) {
                sb.append(" securePort (").append(securePort).append(")");
            }
            Logger.getLogger((String)"org.jboss.as").info((Object)sb.toString());
        } else {
            ModelNode secureSocketBindingNode;
            ModelNode socketBindingNode = HttpManagementResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, model);
            if (socketBindingNode.isDefined()) {
                String bindingName = socketBindingNode.asString();
                socketBindingServiceName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingName});
            }
            if ((secureSocketBindingNode = HttpManagementResourceDefinition.SECURE_SOCKET_BINDING.resolveModelAttribute(context, model)).isDefined()) {
                String bindingName = secureSocketBindingNode.asString();
                secureSocketBindingServiceName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingName});
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Creating http management service using ");
            if (socketBindingServiceName != null) {
                sb.append(" socket-binding (").append(socketBindingServiceName.getSimpleName()).append(")");
            }
            if (secureSocketBindingServiceName != null) {
                sb.append(" secure-socket-binding (").append(secureSocketBindingServiceName.getSimpleName()).append(")");
            }
            Logger.getLogger((String)"org.jboss.as").info((Object)sb.toString());
        }
        ServiceName realmSvcName = null;
        ModelNode realmNode = HttpManagementResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        if (realmNode.isDefined()) {
            realmSvcName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{realmNode.asString()});
        } else {
            Logger.getLogger((String)"org.jboss.as").warn((Object)"No security realm has been defined for the http management service; all access will be unrestricted.");
        }
        HttpManagementService service = new HttpManagementService();
        ServiceBuilder builder = serviceTarget.addService(HttpManagementService.SERVICE_NAME, (Service)service).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.getModelControllerInjector()).addDependency(SocketBindingManagerImpl.SOCKET_BINDING_MANAGER, SocketBindingManager.class, service.getSocketBindingManagerInjector()).addInjection(service.getExecutorServiceInjector(), (Object)Executors.newCachedThreadPool((ThreadFactory)new JBossThreadFactory(new ThreadGroup("HttpManagementService-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext())));
        if (interfaceSvcName != null) {
            builder.addDependency(interfaceSvcName, NetworkInterfaceBinding.class, service.getInterfaceInjector()).addInjection(service.getPortInjector(), (Object)port).addInjection(service.getSecurePortInjector(), (Object)securePort);
        } else {
            if (socketBindingServiceName != null) {
                builder.addDependency(socketBindingServiceName, SocketBinding.class, service.getSocketBindingInjector());
            }
            if (secureSocketBindingServiceName != null) {
                builder.addDependency(secureSocketBindingServiceName, SocketBinding.class, service.getSecureSocketBindingInjector());
            }
        }
        if (realmSvcName != null) {
            builder.addDependency(realmSvcName, SecurityRealmService.class, service.getSecurityRealmInjector());
        }
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = builder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }
}

