/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cacheviews;

import org.infinispan.cacheviews.CacheView;
import org.infinispan.cacheviews.CacheViewListener;
import org.infinispan.cacheviews.PendingCacheViewChanges;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheViewInfo {
    private static final Log log = LogFactory.getLog(CacheViewInfo.class);
    private final String cacheName;
    private final Object lock = new Object();
    private CacheView committedView;
    private CacheView pendingView;
    private volatile CacheViewListener listener;
    private volatile PendingCacheViewChanges pendingChanges;

    public CacheViewInfo(String cacheName, CacheView initialView) {
        log.tracef("%s: Initializing state, initial view is %s", cacheName, initialView);
        this.cacheName = cacheName;
        this.committedView = initialView;
        this.pendingView = null;
        this.pendingChanges = new PendingCacheViewChanges(cacheName);
    }

    public String getCacheName() {
        return this.cacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheView getCommittedView() {
        Object object = this.lock;
        synchronized (object) {
            return this.committedView;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheView getPendingView() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingView;
        }
    }

    public void setListener(CacheViewListener listener) {
        this.listener = listener;
    }

    public CacheViewListener getListener() {
        return this.listener;
    }

    public PendingCacheViewChanges getPendingChanges() {
        return this.pendingChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareView(CacheView newView) {
        log.tracef("%s: Preparing view %s", this.cacheName, newView);
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingView != null) {
                throw new IllegalStateException(String.format("Cannot prepare new view %s on cache %s, we are currently preparing view %s", newView, this.cacheName, this.pendingView));
            }
            if (this.committedView.getViewId() > newView.getViewId()) {
                throw new IllegalStateException(String.format("Cannot prepare new view %s on cache %s, we have already committed view %s", newView, this.cacheName, this.committedView));
            }
            this.pendingView = newView;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitView(int viewId) {
        log.tracef("%s: Committing view %s", this.cacheName, viewId);
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingView == null && viewId == this.committedView.getViewId()) {
                log.tracef("%s: Re-committing view %d", this.cacheName, viewId);
                return;
            }
            if (this.pendingView == null || viewId != this.pendingView.getViewId()) {
                throw new IllegalArgumentException(String.format("Cannot commit view %d, we are currently preparing view %s", viewId, this.pendingView));
            }
            this.committedView = this.pendingView;
            this.pendingView = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackView(int newViewId, int committedViewId) {
        log.tracef("%s: Rolling back to cache view %s, new view id is %d", this.cacheName, this.committedView, newViewId);
        Object object = this.lock;
        synchronized (object) {
            if (!this.committedView.getMembers().isEmpty() && committedViewId != this.committedView.getViewId()) {
                log.cacheViewRollbackIdMismatch(committedViewId, this.committedView.getViewId());
            }
            this.pendingView = null;
            this.committedView = new CacheView(newViewId, this.committedView.getMembers());
        }
    }
}

