/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cacheviews;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.cacheviews.CacheView;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Immutables;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PendingCacheViewChanges {
    private static final Log log = LogFactory.getLog(PendingCacheViewChanges.class);
    private final Object lock = new Object();
    private final String cacheName;
    private int lastViewId;
    private final Set<Address> joiners;
    private final Set<Address> leavers;
    private Set<Address> recoveredMembers;
    private boolean viewInstallationInProgress;

    public PendingCacheViewChanges(String cacheName) {
        this.cacheName = cacheName;
        this.joiners = new HashSet<Address>();
        this.leavers = new HashSet<Address>();
        this.recoveredMembers = Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheView createPendingView(CacheView committedView) {
        Object object = this.lock;
        synchronized (object) {
            if (this.viewInstallationInProgress) {
                log.tracef("Cannot create a new view, there is another view installation in progress", new Object[0]);
                return null;
            }
            if (this.leavers.size() == 0 && this.joiners.size() == 0 && this.recoveredMembers == null) {
                log.tracef("Cannot create a new view, we have no joiners or leavers", new Object[0]);
                return null;
            }
            Collection<Address> baseMembers = this.recoveredMembers != null ? this.recoveredMembers : committedView.getMembers();
            ArrayList<Address> members = new ArrayList<Address>(baseMembers);
            members.addAll(this.joiners);
            members.removeAll(this.leavers);
            this.viewInstallationInProgress = true;
            ++this.lastViewId;
            CacheView pendingView = new CacheView(this.lastViewId, members);
            log.tracef("%s: created new view %s", this.cacheName, pendingView);
            return pendingView;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRollbackViewId() {
        Object object = this.lock;
        synchronized (object) {
            ++this.lastViewId;
            return this.lastViewId;
        }
    }

    public boolean hasChanges() {
        return this.recoveredMembers != null || !this.joiners.isEmpty() || !this.leavers.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChanges(CacheView committedView) {
        Object object = this.lock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                ArrayList<Address> bothJoinerAndLeavers = new ArrayList<Address>(this.joiners);
                bothJoinerAndLeavers.retainAll(this.leavers);
                for (Address node : bothJoinerAndLeavers) {
                    if (!committedView.contains(node)) continue;
                    log.debugf("Node %s should not be a member in view %s, left and then joined before the view was installed", new Object[0]);
                }
            }
            this.leavers.retainAll(committedView.getMembers());
            this.joiners.removeAll(committedView.getMembers());
            this.recoveredMembers = null;
            this.viewInstallationInProgress = false;
            if (committedView.getViewId() > this.lastViewId) {
                this.lastViewId = committedView.getViewId();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestJoin(Address joiner) {
        Object object = this.lock;
        synchronized (object) {
            log.tracef("%s: Node %s is joining", this.cacheName, joiner);
            this.joiners.add(joiner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Address> requestLeave(Collection<Address> leavers) {
        Object object = this.lock;
        synchronized (object) {
            log.tracef("%s: Nodes %s are leaving", this.cacheName, leavers);
            HashSet<Address> leavers2 = new HashSet<Address>(leavers);
            this.joiners.removeAll(leavers2);
            log.tracef("%s: After pruning nodes that have joined but have never installed a view, leavers are %s", this.cacheName, leavers2);
            this.leavers.addAll(leavers2);
            return leavers2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoveredViews(Collection<Address> newMembers, Collection<Address> recoveredJoiners) {
        Object object = this.lock;
        synchronized (object) {
            log.tracef("%s: Coordinator changed, this node is the current coordinator", this.cacheName);
            this.recoveredMembers = new HashSet<Address>(newMembers);
            this.recoveredMembers.removeAll(this.leavers);
            recoveredJoiners.removeAll(this.recoveredMembers);
            this.joiners.addAll(recoveredJoiners);
            log.tracef("%s: Members after coordinator change: %s, joiners: %s, leavers: %s", new Object[]{this.cacheName, this.recoveredMembers, recoveredJoiners, this.leavers});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLatestViewId(int viewId) {
        Object object = this.lock;
        synchronized (object) {
            if (viewId > this.lastViewId) {
                this.lastViewId = viewId;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Address> getLeavers() {
        Object object = this.lock;
        synchronized (object) {
            return Immutables.immutableSetCopy(this.leavers);
        }
    }

    public boolean isViewInstallationInProgress() {
        return this.viewInstallationInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastViewId() {
        Object object = this.lock;
        synchronized (object) {
            return this.lastViewId;
        }
    }
}

