/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Collections;
import java.util.Set;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RemoveCommand
extends AbstractDataWriteCommand {
    private static final Log log = LogFactory.getLog(RemoveCommand.class);
    public static final byte COMMAND_ID = 10;
    protected CacheNotifier notifier;
    boolean successful = true;
    boolean nonExistent = false;
    protected transient Object value;

    public RemoveCommand(Object key, Object value, CacheNotifier notifier, Set<Flag> flags) {
        super(key, flags);
        this.value = value;
        this.notifier = notifier;
    }

    public void init(CacheNotifier notifier) {
        this.notifier = notifier;
    }

    public RemoveCommand() {
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitRemoveCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        CacheEntry e = ctx.lookupEntry(this.key);
        if (e == null || e.isNull()) {
            this.nonExistent = true;
            log.trace("Nothing to remove since the entry is null or we have a null entry");
            if (this.value == null) {
                return null;
            }
            this.successful = false;
            return false;
        }
        if (!(e instanceof MVCCEntry)) {
            ctx.putLookedUpEntry(this.key, null);
        }
        if (this.value != null && e.getValue() != null && !e.getValue().equals(this.value)) {
            this.successful = false;
            return false;
        }
        Object removedValue = e.getValue();
        this.notify(ctx, removedValue, true);
        e.setRemoved(true);
        e.setValid(false);
        if (this instanceof EvictCommand) {
            e.setEvicted(true);
            this.notify(ctx, removedValue, false);
        } else {
            this.notify(ctx, null, false);
        }
        return this.value == null ? removedValue : Boolean.valueOf(true);
    }

    protected void notify(InvocationContext ctx, Object value, boolean isPre) {
        this.notifier.notifyCacheEntryRemoved(this.key, value, isPre, ctx);
    }

    @Override
    public byte getCommandId() {
        return 10;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemoveCommand)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveCommand that = (RemoveCommand)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "RemoveCommand{key=" + this.key + ", value=" + this.value + ", flags=" + this.flags + "}";
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public boolean isConditional() {
        return this.value != null;
    }

    public boolean isNonExistent() {
        return this.nonExistent;
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 10) {
            throw new IllegalStateException("Invalid method id");
        }
        this.key = parameters[0];
        this.flags = parameters.length > 1 ? parameters[1] : Collections.EMPTY_SET;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.flags};
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }
}

