/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.infinispan.config.Configuration;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationDoc;
import org.infinispan.config.ConfigurationException;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.JAXBUnmarshallable;
import org.infinispan.config.parsing.NamespaceFilter;
import org.infinispan.config.parsing.XmlConfigurationParser;
import org.infinispan.util.FileLookup;
import org.infinispan.util.FileLookupFactory;
import org.infinispan.util.StringPropertyReplacer;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@XmlRootElement(name="infinispan")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ConfigurationDoc(name="infinispan")
public class InfinispanConfiguration
implements XmlConfigurationParser,
JAXBUnmarshallable {
    private static final Log log = LogFactory.getLog(InfinispanConfiguration.class);
    public static final String VALIDATING_SYSTEM_PROPERTY = "infinispan.config.validate";
    public static final String SKIP_TOKEN_REPLACEMENT = "infinispan.config.skipTokenReplacement";
    public static final String SCHEMA_SYSTEM_PROPERTY = "infinispan.config.schema";
    private static final String DEFAULT_SCHEMA_LOCATION = String.format("schema/infinispan-config-%s.xsd", "5.1");
    public static final String SCHEMA_URL_SYSTEM_PROPERTY = "infinispan.config.schema.url";
    private static final String DEFAULT_SCHEMA_URL = String.format("http://www.infinispan.org/schemas/infinispan-config-%s.xsd", "5.1");
    private static SoftReference<JAXBContext> jaxbContextReference;
    @XmlElement
    private final GlobalConfiguration global = new GlobalConfiguration();
    @XmlElement(name="default")
    private final Configuration defaultConfiguration = new Configuration();
    @XmlElement(name="namedCache")
    private final List<Configuration> namedCaches = new ArrayList<Configuration>();

    public static InfinispanConfiguration newInfinispanConfiguration(String configFileName, String schemaFileName, ClassLoader cl) throws IOException {
        return InfinispanConfiguration.newInfinispanConfiguration(configFileName, schemaFileName, null, cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InfinispanConfiguration newInfinispanConfiguration(String configFileName, String schemaFileName, ConfigurationBeanVisitor cbv, ClassLoader cl) throws IOException {
        InfinispanConfiguration infinispanConfiguration;
        InputStream inputStream = configFileName != null ? InfinispanConfiguration.findInputStream(configFileName, cl) : null;
        InputStream schemaIS = schemaFileName != null ? InfinispanConfiguration.findSchemaInputStream(schemaFileName) : null;
        try {
            infinispanConfiguration = InfinispanConfiguration.newInfinispanConfiguration(inputStream, schemaIS, cbv);
        }
        catch (Throwable throwable) {
            Util.close((Closeable[])new Closeable[]{inputStream, schemaIS});
            throw throwable;
        }
        Util.close((Closeable[])new Closeable[]{inputStream, schemaIS});
        return infinispanConfiguration;
    }

    public static InfinispanConfiguration newInfinispanConfiguration(String configFileName, ClassLoader cl) throws IOException {
        return InfinispanConfiguration.newInfinispanConfiguration(configFileName, null, cl);
    }

    public static InfinispanConfiguration newInfinispanConfiguration(InputStream config) throws IOException {
        return InfinispanConfiguration.newInfinispanConfiguration(config, null);
    }

    public static InfinispanConfiguration newInfinispanConfiguration(Reader config) throws IOException {
        return InfinispanConfiguration.newInfinispanConfiguration(config, null);
    }

    public static InfinispanConfiguration newInfinispanConfiguration(InputStream config, InputStream schema) throws IOException {
        return InfinispanConfiguration.newInfinispanConfiguration(config, schema, null);
    }

    public static InfinispanConfiguration newInfinispanConfiguration(Reader config, InputStream schema) throws IOException {
        return InfinispanConfiguration.newInfinispanConfiguration(config, schema, null);
    }

    public static InfinispanConfiguration newInfinispanConfiguration(Reader config, InputStream schema, ConfigurationBeanVisitor cbv) throws IOException {
        try {
            Unmarshaller u = InfinispanConfiguration.getJAXBContext().createUnmarshaller();
            NamespaceFilter nf = new NamespaceFilter();
            XMLReader reader = XMLReaderFactory.createXMLReader();
            nf.setParent(reader);
            if (schema != null) {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                u.setSchema(factory.newSchema(new StreamSource(schema)));
                u.setEventHandler(new ValidationEventHandler(){

                    public boolean handleEvent(ValidationEvent event) {
                        int severity = event.getSeverity();
                        return severity != 2 && severity != 1;
                    }
                });
            }
            SAXSource source = null;
            source = InfinispanConfiguration.skipTokenReplacement() ? new SAXSource(nf, new InputSource(config)) : InfinispanConfiguration.replaceProperties(config, nf);
            u.setListener(new Unmarshaller.Listener(){

                public void beforeUnmarshal(Object target, Object parent) {
                    if (target instanceof JAXBUnmarshallable) {
                        ((JAXBUnmarshallable)target).willUnmarshall(parent);
                    }
                }
            });
            InfinispanConfiguration ic = (InfinispanConfiguration)u.unmarshal((Source)source);
            ic.accept(cbv);
            return ic;
        }
        catch (ConfigurationException cex) {
            throw cex;
        }
        catch (NullPointerException npe) {
            throw npe;
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getLocalizedMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public static InfinispanConfiguration newInfinispanConfiguration(InputStream config, InputStream schema, ConfigurationBeanVisitor cbv) throws IOException {
        return InfinispanConfiguration.newInfinispanConfiguration(new InputStreamReader(config), schema, cbv);
    }

    protected static synchronized JAXBContext getJAXBContext() throws JAXBException {
        JAXBContext context;
        JAXBContext jAXBContext = context = jaxbContextReference != null ? jaxbContextReference.get() : null;
        if (context == null) {
            context = JAXBContext.newInstance((Class[])new Class[]{InfinispanConfiguration.class});
            jaxbContextReference = new SoftReference<JAXBContext>(context);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String toXmlString(Object compatibleConfigurationInstance) {
        String string;
        StringWriter writer = new StringWriter(1024);
        try {
            Marshaller m = InfinispanConfiguration.getJAXBContext().createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.marshal(compatibleConfigurationInstance, (Writer)writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                writer.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        writer.close();
        return string;
    }

    private static SAXSource replaceProperties(Reader config, XMLFilter filter) throws Exception {
        String line;
        BufferedReader br = new BufferedReader(config);
        StringBuilder w = new StringBuilder();
        while ((line = br.readLine()) != null) {
            int dollar = line.indexOf(36);
            if (dollar > 0 && line.indexOf(123, dollar) > 0 && line.indexOf(125, dollar) > 0) {
                String replacedLine = StringPropertyReplacer.replaceProperties((String)line);
                if (line.equals(replacedLine)) {
                    log.propertyCouldNotBeReplaced(line.substring(line.indexOf(123) + 1, line.indexOf(125)));
                }
                w.append(replacedLine);
                continue;
            }
            w.append(line);
        }
        return new SAXSource(filter, new InputSource(new StringReader(w.toString())));
    }

    private static boolean skipSchemaValidation() {
        String s = System.getProperty(VALIDATING_SYSTEM_PROPERTY);
        return s != null && !Boolean.parseBoolean(s);
    }

    private static boolean skipTokenReplacement() {
        String s = System.getProperty(SKIP_TOKEN_REPLACEMENT, "false");
        return s != null && Boolean.parseBoolean(s);
    }

    public static InputStream findSchemaInputStream() {
        return InfinispanConfiguration.findSchemaInputStream(null);
    }

    public static InputStream findSchemaInputStream(String localPathToSchema) {
        boolean validating;
        boolean bl = validating = !InfinispanConfiguration.skipSchemaValidation();
        if (!validating) {
            return null;
        }
        FileLookup fileLookup = FileLookupFactory.newInstance();
        InputStream is = null;
        if (localPathToSchema != null) {
            is = fileLookup.lookupFile(localPathToSchema, null);
            if (is != null) {
                log.debugf("Using schema %s", localPathToSchema);
                return is;
            }
            if (log.isDebugEnabled()) {
                log.debugf("Could not find schema on path %s, resolving %s to %s", localPathToSchema, SCHEMA_SYSTEM_PROPERTY, InfinispanConfiguration.schemaPath());
            }
        }
        if ((is = fileLookup.lookupFile(InfinispanConfiguration.schemaPath(), null)) != null) {
            log.debugf("Using schema %s", InfinispanConfiguration.schemaPath());
            return is;
        }
        if (log.isDebugEnabled()) {
            log.debugf("Could not find schema on path %s, resolving %s to %s", InfinispanConfiguration.schemaPath(), SCHEMA_SYSTEM_PROPERTY, InfinispanConfiguration.schemaURL());
        }
        try {
            is = new URL(InfinispanConfiguration.schemaURL()).openStream();
            log.debugf("Using schema %s", InfinispanConfiguration.schemaURL());
            return is;
        }
        catch (Exception e) {
            log.couldNotResolveConfigurationSchema(localPathToSchema, InfinispanConfiguration.schemaPath(), InfinispanConfiguration.schemaURL());
            return null;
        }
    }

    public static String resolveSchemaPath() {
        boolean validating;
        boolean bl = validating = !InfinispanConfiguration.skipSchemaValidation();
        if (!validating) {
            return null;
        }
        return InfinispanConfiguration.schemaPath();
    }

    private static String schemaPath() {
        return System.getProperty(SCHEMA_SYSTEM_PROPERTY, DEFAULT_SCHEMA_LOCATION);
    }

    private static String schemaURL() {
        return System.getProperty(SCHEMA_URL_SYSTEM_PROPERTY, DEFAULT_SCHEMA_URL);
    }

    private InfinispanConfiguration() {
    }

    public void accept(ConfigurationBeanVisitor v) {
        if (v != null) {
            this.global.accept(v);
            this.defaultConfiguration.accept(v);
            for (Configuration c : this.namedCaches) {
                c.accept(v);
            }
            v.visitInfinispanConfiguration(this);
        }
    }

    private static InputStream findInputStream(String fileName, ClassLoader cl) throws FileNotFoundException {
        if (fileName == null) {
            throw new NullPointerException("File name cannot be null!");
        }
        FileLookup fileLookup = FileLookupFactory.newInstance();
        InputStream is = fileLookup.lookupFile(fileName, cl);
        if (is == null) {
            throw new FileNotFoundException("File " + fileName + " could not be found, either on the classpath or on the file system!");
        }
        return is;
    }

    @Override
    public Configuration parseDefaultConfiguration() throws ConfigurationException {
        return this.defaultConfiguration;
    }

    @Override
    public GlobalConfiguration parseGlobalConfiguration() {
        return this.global;
    }

    @Override
    public Map<String, Configuration> parseNamedConfigurations() throws ConfigurationException {
        HashMap<String, Configuration> map = new HashMap<String, Configuration>(7);
        for (Configuration conf : this.namedCaches) {
            map.put(conf.getName(), conf);
        }
        return map;
    }

    @Override
    public void willUnmarshall(Object parent) {
    }

    public String toXmlString() {
        return InfinispanConfiguration.toXmlString(this);
    }
}

