/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config.parsing;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.infinispan.config.ConfigurationException;
import org.infinispan.util.BeanUtils;
import org.infinispan.util.StringPropertyReplacer;
import org.infinispan.util.TypedProperties;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlConfigHelper {
    private static final Log log = LogFactory.getLog(XmlConfigHelper.class);

    public static String getTagContents(Element elem, String value, String elementName, String attributeName) {
        NodeList list = elem.getElementsByTagName(elementName);
        for (int s = 0; s < list.getLength(); ++s) {
            Element element;
            String name;
            Node node = list.item(s);
            if (node.getNodeType() != 1 || !(name = (element = (Element)node).getAttribute(attributeName)).equals(value)) continue;
            return XmlConfigHelper.getElementContent(element, true);
        }
        return null;
    }

    public static String getAttributeValue(Element elem, String elementName, String attributeName) {
        NodeList list = elem.getElementsByTagName(elementName);
        for (int s = 0; s < list.getLength(); ++s) {
            Node node = list.item(s);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String value = element.getAttribute(attributeName);
            return value == null ? null : StringPropertyReplacer.replaceProperties((String)value);
        }
        return null;
    }

    public static Element getSubElement(Element element, String subElementName) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !subElementName.equals(((Element)node).getTagName())) continue;
            return (Element)node;
        }
        if (log.isDebugEnabled()) {
            log.debugf("getSubElement(): Does not exist for %s", subElementName);
        }
        return null;
    }

    public static String getElementContent(Element element, boolean trim) {
        NodeList nl = element.getChildNodes();
        StringBuilder attributeText = new StringBuilder();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Text)) continue;
            attributeText.append(StringPropertyReplacer.replaceProperties((String)((Text)n).getData()));
        }
        if (trim) {
            return attributeText.toString().trim();
        }
        return attributeText.toString();
    }

    public static String readStringContents(Element element, String elementName) {
        NodeList nodes = element.getElementsByTagName(elementName);
        if (nodes.getLength() > 0) {
            Node node = nodes.item(0);
            Element ne = (Element)node;
            NodeList nl2 = ne.getChildNodes();
            Node node2 = nl2.item(0);
            if (node2 != null) {
                String value = node2.getNodeValue();
                if (value == null) {
                    return "";
                }
                return StringPropertyReplacer.replaceProperties((String)value.trim());
            }
            return "";
        }
        return "";
    }

    public static String escapeBackslashes(String value) {
        StringBuilder buf = new StringBuilder(value);
        for (int looper = 0; looper < buf.length(); ++looper) {
            char curr = buf.charAt(looper);
            char next = '\u0000';
            if (looper + 1 < buf.length()) {
                next = buf.charAt(looper + 1);
            }
            if (curr != '\\') continue;
            if (next != '\\') {
                buf.insert(looper, '\\');
            }
            ++looper;
        }
        return buf.toString();
    }

    public static Properties readPropertiesContents(Element element, String elementName) {
        String stringContents = XmlConfigHelper.readStringContents(element, elementName);
        if (stringContents == null) {
            return new Properties();
        }
        stringContents = XmlConfigHelper.escapeBackslashes(stringContents);
        ByteArrayInputStream is = null;
        Properties properties = null;
        try {
            is = new ByteArrayInputStream(stringContents.trim().getBytes("ISO8859_1"));
            properties = new Properties();
            properties.load(is);
            is.close();
        }
        catch (IOException e) {
            log.errorReadingProperties(e);
            throw new ConfigurationException("Exception occured while reading properties from XML document", e);
        }
        return properties;
    }

    public static Properties readPropertiesContents(Element element) {
        return XmlConfigHelper.readPropertiesContents(element, "properties");
    }

    public static boolean readBooleanContents(Element element, String elementName) {
        return XmlConfigHelper.readBooleanContents(element, elementName, false);
    }

    public static boolean readBooleanContents(Element element, String elementName, boolean defaultValue) {
        String val = XmlConfigHelper.readStringContents(element, elementName);
        if (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("false")) {
            return Boolean.valueOf(val);
        }
        return defaultValue;
    }

    public static Element stringToElement(String xml) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes("utf8"));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document d = builder.parse(bais);
        bais.close();
        return d.getDocumentElement();
    }

    public static Element getFirstChildElement(Element element) {
        Node child;
        for (child = element.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    public static Element getDocumentRoot(InputStream is) {
        try {
            InputSource xmlInp = new InputSource(is);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder parser = docBuilderFactory.newDocumentBuilder();
            Document doc = parser.parse(xmlInp);
            Element root = doc.getDocumentElement();
            root.normalize();
            return root;
        }
        catch (SAXParseException err) {
            log.error("Configurator SAXParse error", err);
        }
        catch (SAXException e) {
            log.error("Configurator SAX error", e);
        }
        catch (Exception pce) {
            log.error("Configurator general error", pce);
        }
        return null;
    }

    public static boolean readBooleanAttribute(Element elem, String elementName, String attributeName, boolean defaultValue) {
        String val = XmlConfigHelper.getAttributeValue(elem, elementName, attributeName);
        if (val != null && (val.equalsIgnoreCase("true") || val.equalsIgnoreCase("false"))) {
            return Boolean.valueOf(val);
        }
        return defaultValue;
    }

    public static void setValues(Object target, Map<?, ?> attribs, boolean isXmlAttribs, boolean failOnMissingSetter) {
        Class<?> objectClass = target.getClass();
        for (Map.Entry<?, ?> entry : attribs.entrySet()) {
            String propName = (String)entry.getKey();
            String setter = BeanUtils.setterName(propName);
            try {
                Method method;
                if (isXmlAttribs) {
                    method = objectClass.getMethod(setter, Element.class);
                    method.invoke(target, entry.getValue());
                    continue;
                }
                method = objectClass.getMethod(setter, String.class);
                method.invoke(target, entry.getValue());
                continue;
            }
            catch (NoSuchMethodException me) {
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to invoke setter " + setter + " on " + objectClass, e);
            }
            boolean setterFound = false;
            for (Method m : objectClass.getMethods()) {
                if (!setter.equals(m.getName())) continue;
                Class<?>[] paramTypes = m.getParameterTypes();
                if (paramTypes.length != 1) {
                    if (!log.isTraceEnabled()) continue;
                    log.tracef("Rejecting setter %s on class %s due to incorrect number of parameters", m, objectClass);
                    continue;
                }
                Class<?> parameterType = paramTypes[0];
                PropertyEditor editor = PropertyEditorManager.findEditor(parameterType);
                if (editor == null) {
                    throw new ConfigurationException("Couldn't find a property editor for parameter type " + parameterType);
                }
                editor.setAsText((String)attribs.get(propName));
                Object parameter = editor.getValue();
                try {
                    m.invoke(target, parameter);
                    setterFound = true;
                    break;
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to invoke setter " + setter + " on " + objectClass, e);
                }
            }
            if (setterFound || !failOnMissingSetter) continue;
            throw new ConfigurationException("Couldn't find a setter named [" + setter + "] which takes a single parameter, for parameter " + propName + " on class [" + objectClass + "]");
        }
    }

    public static Properties extractProperties(Element source) {
        TypedProperties p = new TypedProperties();
        NodeList list = source.getElementsByTagName("property");
        if (list == null) {
            return null;
        }
        for (int loop = 0; loop < list.getLength(); ++loop) {
            Node node = list.item(loop);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String name = element.getAttribute("name");
            String valueStr = element.getAttribute("value");
            if (valueStr.length() <= 0) continue;
            valueStr = valueStr.trim();
            valueStr = StringPropertyReplacer.replaceProperties((String)valueStr);
            p.put(name, valueStr);
        }
        return p.isEmpty() ? null : p;
    }

    public static String toString(Element e) {
        try {
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer xform = tfactory.newTransformer();
            DOMSource src = new DOMSource(e);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            xform.transform(src, result);
            return writer.toString();
        }
        catch (Exception ex) {
            return "Unable to convert to string: " + ex.toString();
        }
    }
}

