/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.beans.PropertyEditorSupport;
import org.infinispan.configuration.cache.AbstractLockSupportCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfiguration;
import org.infinispan.configuration.cache.LoaderConfigurationBuilder;

public class FileCacheStoreConfigurationBuilder
extends AbstractLockSupportCacheStoreConfigurationBuilder<FileCacheStoreConfiguration> {
    private String location;
    private long fsyncInterval;
    private FsyncMode fsyncMode;
    private int streamBufferSize;

    protected FileCacheStoreConfigurationBuilder(LoaderConfigurationBuilder builder) {
        super(builder);
    }

    public FileCacheStoreConfigurationBuilder location(String location) {
        this.location = location;
        return this;
    }

    public FileCacheStoreConfigurationBuilder fsyncInterval(long fsyncInterval) {
        this.fsyncInterval = fsyncInterval;
        return this;
    }

    public FileCacheStoreConfigurationBuilder fsyncMode(FsyncMode fsyncMode) {
        this.fsyncMode = fsyncMode;
        return this;
    }

    public FileCacheStoreConfigurationBuilder streamBufferSize(int streamBufferSize) {
        this.streamBufferSize = streamBufferSize;
        return this;
    }

    @Override
    void validate() {
    }

    @Override
    FileCacheStoreConfiguration create() {
        return new FileCacheStoreConfiguration(this.lockAcquistionTimeout, this.lockConcurrencyLevel, this.location, this.fsyncInterval, this.fsyncMode, this.streamBufferSize);
    }

    @Override
    public FileCacheStoreConfigurationBuilder purgeOnStartup(boolean purgeOnStartup) {
        super.purgeOnStartup(purgeOnStartup);
        return this;
    }

    @Override
    public FileCacheStoreConfigurationBuilder purgeSynchronously(boolean purgeSynchronously) {
        super.purgeSynchronously(purgeSynchronously);
        return this;
    }

    @Override
    public FileCacheStoreConfigurationBuilder fetchPersistentState(boolean fetchPersistentState) {
        super.fetchPersistentState(fetchPersistentState);
        return this;
    }

    @Override
    public FileCacheStoreConfigurationBuilder ignoreModifications(boolean ignoreModifications) {
        super.ignoreModifications(ignoreModifications);
        return this;
    }

    @Override
    public FileCacheStoreConfigurationBuilder lockAcquistionTimeout(long lockAcquistionTimeout) {
        super.lockAcquistionTimeout(lockAcquistionTimeout);
        return this;
    }

    @Override
    public FileCacheStoreConfigurationBuilder lockConcurrencyLevel(int lockConcurrencyLevel) {
        super.lockConcurrencyLevel(lockConcurrencyLevel);
        return this;
    }

    public static class FsyncModeEditor
    extends PropertyEditorSupport {
        private FsyncMode mode;

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if (text.equals("default")) {
                this.mode = FsyncMode.DEFAULT;
            } else if (text.equals("perWrite")) {
                this.mode = FsyncMode.PER_WRITE;
            } else if (text.equals("periodic")) {
                this.mode = FsyncMode.PERIODIC;
            } else {
                throw new IllegalArgumentException("Unknown fsyncMode value: " + text);
            }
        }

        @Override
        public Object getValue() {
            return this.mode;
        }
    }

    public static enum FsyncMode {
        DEFAULT,
        PER_WRITE,
        PERIODIC;

    }
}

